% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_download.R
\name{get_package_download}
\alias{get_package_download}
\title{Get CRAN Package Download Count}
\usage{
get_package_download(package_name, timeline = "grand-total")
}
\arguments{
\item{package_name}{A character string specifying the package name.}

\item{timeline}{A character string specifying the timeline ('last-month', or 'grand-total').}
}
\value{
An integer representing the total number of downloads.
}
\description{
Retrieves the download count for a given CRAN package from the CRAN logs API.
}
\examples{
\dontrun{
total_download_result <- get_package_download('ggplot2')

month_download_result <- get_package_download('dplyr', 'last-month')
}
}
