% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_util.R
\name{is_valid_prob_triple}
\alias{is_valid_prob_triple}
\title{Verify that a triple of essential probability inputs is valid.}
\usage{
is_valid_prob_triple(prev, sens, spec)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).}
}
\value{
A Boolean value:
\code{TRUE} if the probabilities provided are valid;
otherwise \code{FALSE}.
}
\description{
\code{is_valid_prob_triple} is a \strong{deprecated} function that verifies that
a set of 3 numeric inputs can be interpreted as a
valid set of 3 probabilities.
}
\details{
\code{is_valid_prob_triple} is a simplified version
of \code{\link{is_valid_prob_set}}.
It is a quick wrapper function that only verifies
\code{\link{is_prob}} for all of its 3 arguments.

\code{is_valid_prob_triple} does not compute or return numeric variables.
Use \code{\link{is_extreme_prob_set}} to verify extreme cases and
\code{\link{comp_complete_prob_set}} to complete sets of valid probabilities.
}
\examples{
# ways to work:
is_valid_prob_triple(0, 0, 0)    # => TRUE
is_valid_prob_triple(1, 1, 1)    # => TRUE

## ways to fail:
# is_valid_prob_triple(0, 0)       # => ERROR (as no triple)
# is_valid_prob_triple(0, 0, 7)    # => FALSE + warning (beyond range)
# is_valid_prob_triple(0, NA, 0)   # => FALSE + warning (NA)
# is_valid_prob_triple("p", 0, 0)  # => FALSE + warning (non-numeric)

}
\seealso{
\code{\link{is_extreme_prob_set}} verifies extreme cases;
\code{\link{is_valid_prob_set}} verifies sets of probability inputs;
\code{\link{is_valid_prob_pair}} verifies that probability pairs are complements;
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{as_pc}} displays a probability as a percentage;
\code{\link{as_pb}} displays a percentage as probability.

Other verification functions: 
\code{\link{is_complement}()},
\code{\link{is_extreme_prob_set}()},
\code{\link{is_freq}()},
\code{\link{is_integer}()},
\code{\link{is_matrix}()},
\code{\link{is_perc}()},
\code{\link{is_prob}()},
\code{\link{is_suff_prob_set}()},
\code{\link{is_valid_prob_pair}()},
\code{\link{is_valid_prob_set}()}
}
\concept{verification functions}
