% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotting.R
\name{.ggCellViolin}
\alias{.ggCellViolin}
\title{Produce single violin plot with data frame passed from upstream}
\usage{
.ggCellViolin(
  plotDF,
  y,
  groupBy = NULL,
  colorBy = NULL,
  violin = TRUE,
  violinAlpha = 0.8,
  violinWidth = 0.9,
  box = FALSE,
  boxAlpha = 0.6,
  boxWidth = 0.4,
  dot = FALSE,
  dotColor = "black",
  dotSize = getOption("ligerDotSize"),
  raster = NULL,
  seed = 1,
  ...
)
}
\arguments{
\item{plotDF}{Data frame like object (fortifiable) that contains all
necessary information to make the plot.}

\item{y, groupBy, colorBy}{See \code{\link{plotCellViolin}}.}

\item{violin, box, dot}{Logical, whether to add violin plot, box plot or dot
(scatter) plot, respectively. Layers are added in the order of dot, violin,
and violin on the top surface. By default, only violin plot is generated.}

\item{violinAlpha, boxAlpha}{Numeric, controls the transparency of layers.
Default \code{0.8}, \code{0.6}, respectively.}

\item{violinWidth, boxWidth}{Numeric, controls the width of violin/box
bounding box. Default \code{0.9} and \code{0.4}.}

\item{dotColor, dotSize}{Numeric, globally controls the appearance of all
dots. Default \code{"black"} and \code{getOption("ligerDotSize")} (1).}

\item{raster}{Logical, whether to rasterize the dot plot. Default \code{NULL}
automatically rasterizes the dot plot when number of total cells to be
plotted exceeds 100,000.}

\item{seed}{Random seed for reproducibility. Default \code{1}.}

\item{...}{More theme setting arguments passed to
\code{\link{.ggplotLigerTheme}}.}
}
\value{
ggplot object by default. When \code{plotly = TRUE}, returns
plotly (htmlwidget) object.
}
\description{
Produce single violin plot with data frame passed from upstream
}
