% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotting.R
\name{.ggplotLigerTheme}
\alias{.ggplotLigerTheme}
\title{Generic ggplot theme setting for rliger package}
\usage{
.ggplotLigerTheme(
  plot,
  title = NULL,
  subtitle = NULL,
  xlab = TRUE,
  ylab = TRUE,
  legendColorTitle = NULL,
  legendFillTitle = NULL,
  legendShapeTitle = NULL,
  legendSizeTitle = NULL,
  showLegend = TRUE,
  legendPosition = "right",
  baseSize = getOption("ligerBaseSize"),
  titleSize = NULL,
  subtitleSize = NULL,
  xTextSize = NULL,
  xFacetSize = NULL,
  xTitleSize = NULL,
  yTextSize = NULL,
  yFacetSize = NULL,
  yTitleSize = NULL,
  legendTextSize = NULL,
  legendTitleSize = NULL,
  legendDotSize = 4,
  panelBorder = FALSE,
  legendNRow = NULL,
  legendNCol = NULL,
  colorLabels = NULL,
  colorValues = NULL,
  colorPalette = "magma",
  colorDirection = -1,
  naColor = "#DEDEDE",
  colorLow = NULL,
  colorMid = NULL,
  colorHigh = NULL,
  colorMidPoint = NULL,
  plotly = FALSE
)
}
\arguments{
\item{plot}{ggplot object passed from wrapper plotting functions}

\item{title, subtitle, xlab, ylab}{Main title, subtitle or X/Y axis title text.
By default, no main title or subtitle will be set, and X/Y axis title will be
the names of variables used for plotting. Use \code{NULL} to hide elements.
\code{TRUE} for \code{xlab} or \code{ylab} shows default values.}

\item{legendColorTitle, legendFillTitle, legendShapeTitle, legendSizeTitle}{Set
alternative title text for legend on aes of color, fill, shape and size,
respectively. Default \code{NULL} shows the original variable name.}

\item{showLegend}{Whether to show the legend. Default \code{TRUE}.}

\item{legendPosition}{Text indicating where to place the legend. Choose from
\code{"top"}, \code{"bottom"}, \code{"left"} or \code{"right"}. Default
\code{"right"}.}

\item{baseSize}{One-parameter control of all text sizes. Individual text
element sizes can be controlled by other size arguments. "Title" sizes are
2 points larger than "text" sizes when being controlled by this.}

\item{titleSize, xTitleSize, yTitleSize, legendTitleSize}{Size of main title,
axis titles and legend title. Default \code{NULL} controls by
\code{baseSize + 2}.}

\item{subtitleSize, xTextSize, yTextSize, legendTextSize}{Size of subtitle text,
axis texts and legend text. Default \code{NULL} controls by \code{baseSize}.}

\item{xFacetSize, yFacetSize}{Size of facet label text. Default \code{NULL}
controls by \code{baseSize - 2}.}

\item{legendDotSize}{Allow dots in legend region to be large enough to see
the colors/shapes clearly. Default \code{4}.}

\item{panelBorder}{Whether to show rectangle border of the panel instead of
using ggplot classic bottom and left axis lines. Default \code{FALSE}.}

\item{legendNRow, legendNCol}{Integer, when too many categories in one
variable, arranges number of rows or columns. Default \code{NULL},
automatically split to \code{ceiling(levels(variable)/10)} columns.}

\item{colorLabels, colorValues}{Each a vector with as many values as the
number of categories for the categorical coloring aesthetics. Labels will be
the shown text and values will be the color code. These are passed to
\code{\link[ggplot2]{scale_color_manual}}. Default uses an internal selected
palette if there are <= 26 colors needed, or ggplot hues otherwise, and plot
original labels (levels of the factor).}

\item{colorPalette}{For continuous coloring, an index or a palette name to
select from available options from ggplot
\code{\link[ggplot2]{scale_brewer}} or \code{\link[viridisLite]{viridis}}.
Default \code{"magma"}.}

\item{colorDirection}{Choose \code{1} or \code{-1}. Applied when
\code{colorPalette} is from Viridis options. Default \code{-1} use darker
color for higher value, while \code{1} reverses this direction.}

\item{naColor}{The color code for \code{NA} values. Default \code{"#DEDEDE"}.
\code{\link[ggplot2]{scale_colour_gradient2}}. Default \code{NULL}.}

\item{colorLow, colorMid, colorHigh, colorMidPoint}{All four of these must be
specified to customize palette with}

\item{plotly}{Whether to use plotly to enable web based interactive browsing
for the plot. Requires installation of package "plotly". Default
\code{FALSE}.}
}
\value{
Updated ggplot object by default. When \code{plotly = TRUE}, returns
plotly (htmlwidget) object.
}
\description{
Controls content and size of all peripheral texts.
}
