% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{makeFeatureMatrix}
\alias{makeFeatureMatrix}
\title{Fast calculation of feature count matrix}
\usage{
makeFeatureMatrix(bedmat, barcodes)
}
\arguments{
\item{bedmat}{A feature count list generated by bedmap}

\item{barcodes}{A list of barcodes}
}
\value{
A feature count matrix with features as rows and barcodes as
columns
}
\description{
Fast calculation of feature count matrix
}
\examples{
\dontrun{
gene.counts <- makeFeatureMatrix(genes.bc, barcodes)
promoter.counts <- makeFeatureMatrix(promoters.bc, barcodes)
samnple <- gene.counts + promoter.counts
}
}
