% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotDensityDimRed}
\alias{plotDensityDimRed}
\title{Create density plot basing on specified coordinates}
\usage{
plotDensityDimRed(
  object,
  useDimRed = NULL,
  splitBy = NULL,
  combinePlot = TRUE,
  minDensity = 8,
  contour = TRUE,
  contourLineWidth = 0.3,
  contourBins = 5,
  dot = TRUE,
  dotColor = "grey",
  dotSize = 0.6,
  dotAlpha = 0.3,
  dotRaster = NULL,
  title = NULL,
  legendFillTitle = "Density",
  colorPalette = "magma",
  colorDirection = -1,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object}

\item{useDimRed}{Name of the variable storing dimensionality reduction result
in the \code{cellMeta} slot. Default uses default dimension reduction.}

\item{splitBy}{Character vector of categorical variable names in
\code{cellMeta} slot. Split all cells by groupings on this/these variable(s)
to produce a density plot containing only the cells in each group. Default
\code{NULL}.}

\item{combinePlot}{Logical, whether to utilize
\code{\link[cowplot]{plot_grid}} to combine multiple plots into one. Default
\code{TRUE} returns combined ggplot. \code{FALSE} returns a list of ggplot
or a single ggplot when only one plot is requested.}

\item{minDensity}{A positive number to filter out low density region colored
on plot. Default \code{8}. Setting zero will show density on the whole panel.}

\item{contour}{Logical, whether to draw the contour line. Default
\code{TRUE}.}

\item{contourLineWidth}{Numeric, the width of the contour line. Default
\code{0.3}.}

\item{contourBins}{Number of contour bins. Higher value generates more
contour lines. Default \code{5}.}

\item{dot}{Logical, whether to add scatter plot of all cells, even when
density plot is splitted with \code{splitBy}. Default \code{TRUE}.}

\item{dotColor, dotSize, dotAlpha}{Numeric, controls the appearance of all
dots. Default \code{"grey"}, \code{0.6} and \code{0.3}, respectively.}

\item{dotRaster}{Logical, whether to rasterize the scatter plot. Default
\code{NULL} automatically rasterizes the dots when number of total cells to
be plotted exceeds 100,000.}

\item{title}{Text of main title of the plots. Default \code{NULL}. Length
of character vector input should match with number of plots generated.}

\item{legendFillTitle}{Text of legend title. Default \code{"Density"}.}

\item{colorPalette}{Name of the option for
\code{\link[ggplot2]{scale_fill_viridis_c}}. Default \code{"magma"}.}

\item{colorDirection}{Color gradient direction for
\code{\link[ggplot2]{scale_fill_viridis_c}}. Default \code{-1}.}

\item{...}{More theme setting arguments passed to
\code{\link{.ggplotLigerTheme}}.}
}
\value{
A ggplot object when only one plot is generated, A ggplot object
combined with \code{\link[cowplot]{plot_grid}} when multiple plots and
\code{combinePlot = TRUE}. A list of ggplot when multiple plots and
\code{combinePlot = FALSE}.
}
\description{
This function shows the cell density presented in a 2D
dimensionality reduction coordinates. Density is shown with coloring and
contour lines. A scatter plot of the dimensionality reduction is added as
well. The density plot can be splitted by categorical variables (e.g.
\code{"dataset"}), while the scatter plot will always be shown for all cells
in subplots as a reference of the global structure.
}
\examples{
# Example dataset has small number of cells, thus cutoff adjusted.
plotDensityDimRed(pbmcPlot, minDensity = 1)
}
