/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.attributesID;

import dmLab.array.functions.DiscFunctions;
import dmLab.mcfs.attributesID.IDEdge;
import dmLab.mcfs.attributesID.IDEdgeIterator;
import dmLab.mcfs.attributesID.IDEntity;
import dmLab.mcfs.attributesID.IDLink;
import dmLab.mcfs.attributesID.IDList;
import dmLab.mcfs.attributesID.IDProps;
import dmLab.mcfs.attributesID.graph.IDGraph;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.utils.MyDict;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public final class AttributesID
implements Iterable<IDEdge> {
    private HashMap<IDLink, IDProps> myIDMap;
    private MyDict myDict;
    private float maxID;
    private float minID;
    private boolean directedGraph;
    private boolean selfID;
    public static String ID_FILE_HEADER = "parent,child,weight";
    public static String ID_FILE_HEADER_OLD = "edge_a,edge_b,weight";

    /*
     * WARNING - void declaration
     */
    private AttributesID(MyDict myDict, boolean directed, boolean selfID) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.myDict = var1_1;
        this.directedGraph = var2_2;
        this.selfID = var3_3;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public AttributesID(String[] attributes, boolean directed, boolean selfID) {
        void var1_1;
        this.myDict = new MyDict((String[])var1_1);
        this.directedGraph = true;
        this.selfID = false;
        this.init();
    }

    public AttributesID(boolean directed, boolean selfID) {
        this.myDict = new MyDict();
        this.directedGraph = true;
        this.selfID = false;
        this.init();
    }

    public final void init() {
        this.myIDMap = new HashMap();
        this.minID = Float.MAX_VALUE;
        this.maxID = Float.MIN_VALUE;
    }

    public final int getNodesNumber() {
        return this.myDict.size();
    }

    public final int addAttributesID(AttributesID attrID) {
        IDLink[] myIDLinks = new IDLink[1];
        myIDLinks = attrID.myIDMap.keySet().toArray(myIDLinks);
        int i = 0;
        while (i < myIDLinks.length) {
            IDLink link = myIDLinks[i];
            if (link != null) {
                IDProps props = attrID.myIDMap.get(link);
                this.putID(link, props);
            }
            ++i;
        }
        return this.myIDMap.size();
    }

    /*
     * WARNING - void declaration
     */
    public final int addID(String parent, String child, float weight) {
        if (!this.selfID && parent.equalsIgnoreCase(child)) {
            return this.myIDMap.size();
        }
        this.putID(parent, child, weight);
        if (!this.directedGraph) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.putID((String)var2_2, (String)var1_1, (float)var3_3);
        }
        return this.myIDMap.size();
    }

    /*
     * WARNING - void declaration
     */
    private int putID(String parent, String child, float weight) {
        void var3_6;
        void var1_3;
        void var2_5;
        int parentId = this.myDict.put(parent);
        int childId = this.myDict.put(child);
        IDLink link = new IDLink(parentId, (int)var2_5);
        return this.putID((IDLink)var1_3, new IDProps((float)var3_6));
    }

    /*
     * WARNING - void declaration
     */
    private int putID(IDLink link, IDProps props) {
        IDProps myIDProps = this.myIDMap.get(link);
        if (myIDProps == null) {
            void var1_1;
            myIDProps = props;
            this.myIDMap.put((IDLink)var1_1, props);
        } else {
            void var2_2;
            myIDProps.add((IDProps)var2_2);
        }
        if (myIDProps.weight > this.maxID) {
            this.maxID = myIDProps.weight;
        }
        if (myIDProps.weight < this.minID) {
            void var3_3;
            this.minID = var3_3.weight;
        }
        return this.myIDMap.size();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(ID_FILE_HEADER).append('\n');
        IDLink[] myIDLinksArray = new IDLink[1];
        myIDLinksArray = this.myIDMap.keySet().toArray(myIDLinksArray);
        int i = 0;
        while (i < myIDLinksArray.length) {
            IDLink link = myIDLinksArray[i];
            if (link != null) {
                IDProps props = this.myIDMap.get(link);
                tmp.append(link.toString(this.myDict)).append(",").append(props.toString()).append("\n");
            }
            ++i;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String toConnString() {
        void var2_2;
        String[] attributes = this.myDict.getKeys();
        StringBuffer tmp = new StringBuffer();
        IDList connLists = this.getIDList();
        int i = 0;
        while (i < attributes.length) {
            int attrId = this.myDict.get(attributes[i]);
            Integer[] vals = connLists.getValues(attrId);
            if (vals != null) {
                tmp.append(attributes[i]);
                Object[] myIDEntityArray = new IDEntity[vals.length];
                int j = 0;
                while (j < vals.length) {
                    IDLink link = new IDLink(attrId, vals[j]);
                    IDProps props = this.myIDMap.get(link);
                    myIDEntityArray[j] = new IDEntity(link, props);
                    ++j;
                }
                Arrays.sort(myIDEntityArray);
                j = 0;
                while (j < myIDEntityArray.length) {
                    tmp.append(',').append(this.myDict.get(((IDEntity)myIDEntityArray[j]).link.childId)).append("(" + ((IDEntity)myIDEntityArray[j]).props.toString() + ")");
                    ++j;
                }
                tmp.append('\n');
            }
            ++i;
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private IDList getIDList() {
        void var3_5;
        String[] attributes = this.myDict.getKeys();
        int[] attrIds = new int[attributes.length];
        int i = 0;
        while (i < attributes.length) {
            attrIds[i] = this.myDict.get(attributes[i]);
            ++i;
        }
        IDList retIDList = new IDList(attrIds);
        IDLink[] linkArray = new IDLink[1];
        linkArray = this.myIDMap.keySet().toArray(linkArray);
        int i2 = 0;
        while (i2 < linkArray.length) {
            IDLink link = linkArray[i2];
            if (link != null) {
                retIDList.put(link.parentId, link.childId);
            }
            ++i2;
        }
        return var3_5;
    }

    public final boolean save(String fileName) {
        return DiscFunctions.saveString(fileName, this.toConnString());
    }

    /*
     * WARNING - void declaration
     */
    public final AttributesID filter(float minWeight, AttributesRI importance, int attrNumber) {
        void var1_1;
        Ranking ranking = null;
        String[] attributes = null;
        if (importance != null) {
            void var3_4;
            void var2_3;
            void v0 = var2_3;
            ranking = v0.getTopRankingSize(v0.mainMeasureIdx, (int)var3_4);
        }
        if (ranking != null) {
            attributes = ranking.getAttributesNames();
        }
        AttributesID attributesID = this.filter(attributes, (float)var1_1);
        return attributesID;
    }

    /*
     * WARNING - void declaration
     */
    private AttributesID filter(String[] attributes, float minWeight) {
        void var3_3;
        AttributesID retAttrID = new AttributesID(this.myDict.clone(), this.directedGraph, this.selfID);
        HashSet<Integer> attributesSet = null;
        if (attributes != null) {
            attributesSet = new HashSet<Integer>();
            int i = 0;
            while (i < attributes.length) {
                Integer currAttrId = this.myDict.get(attributes[i]);
                if (currAttrId != null) {
                    attributesSet.add(currAttrId);
                }
                ++i;
            }
        }
        IDLink[] linksArray = new IDLink[1];
        linksArray = this.myIDMap.keySet().toArray(linksArray);
        int i = 0;
        while (i < linksArray.length) {
            IDLink link = linksArray[i];
            if (link != null) {
                IDProps iDProps;
                IDProps props = this.myIDMap.get(link);
                boolean put = iDProps.weight >= minWeight;
                put = attributesSet == null ? (put &= true) : (attributesSet.contains(link.parentId) && attributesSet.contains(link.childId) ? (put &= true) : false);
                if (put) {
                    void var1_1;
                    retAttrID.putID((IDLink)var1_1, props);
                }
            }
            ++i;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final IDGraph toGraph(float minWeight2, AttributesRI importance, int attrNumber) {
        void var1_2;
        void var2_3;
        void var3_4;
        AttributesID minWeight2 = this.filter(minWeight2, importance, (int)var3_4);
        IDGraph graph = minWeight2.toGraph();
        graph.setNodesWeights((AttributesRI)var2_3);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private IDGraph toGraph() {
        void var3_3;
        void var2_2;
        void var1_1;
        float minID = Float.MAX_VALUE;
        float maxID = Float.MIN_VALUE;
        IDGraph graph = new IDGraph();
        IDLink[] linksArray = new IDLink[1];
        linksArray = this.myIDMap.keySet().toArray(linksArray);
        int i = 0;
        while (i < linksArray.length) {
            IDLink link = linksArray[i];
            if (link != null) {
                float f;
                IDProps iDProps = this.myIDMap.get(link);
                float weight = iDProps.weight;
                if (f > maxID) {
                    maxID = weight;
                }
                if (weight < minID) {
                    minID = weight;
                }
                graph.addEdge(this.myDict.get(link.parentId), this.myDict.get(link.childId), weight);
            }
            ++i;
        }
        graph.setMinEdgeWeight((float)var1_1);
        graph.setMaxEdgeWeight((float)var2_2);
        return var3_3;
    }

    public final float getMaxID() {
        return this.maxID;
    }

    /*
     * WARNING - void declaration
     */
    public final float getIDWeight(int topSize) {
        void var3_5;
        void var1_2;
        ArrayList<Float> w = new ArrayList<Float>();
        IDLink[] linksArray = new IDLink[1];
        linksArray = this.myIDMap.keySet().toArray(linksArray);
        int i = 0;
        while (i < linksArray.length) {
            IDLink link = linksArray[i];
            if (link != null) {
                w.add(Float.valueOf(this.myIDMap.get((Object)link).weight));
            }
            ++i;
        }
        Float[] f = new Float[1];
        f = var1_2.toArray(f);
        Arrays.sort((Object[])f);
        if (f.length - 20 < 0) {
            return f[0].floatValue();
        }
        void v0 = var3_5;
        return v0[((void)v0).length - 20].floatValue();
    }

    @Override
    public final Iterator<IDEdge> iterator() {
        IDEdgeIterator iDEdgeIterator = new IDEdgeIterator(this.myIDMap, this.myDict);
        return iDEdgeIterator;
    }
}

