% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{covNPD}
\alias{covNPD}
\title{NPD estimator for *covariance* based on Qn}
\usage{
covNPD(data, eigenTol = 1e-06, convTol = 1e-07, psdTol = 1e-08, maxit = 1000L)
}
\arguments{
\item{data}{the n by p raw data matrix}

\item{eigenTol}{tolerance in eigen system, used in finding nearest positive matrix}

\item{convTol}{tolerance in cov, used in finding nearest positive matrix}

\item{psdTol}{tolerance in psd, used in finding nearest positive matrix}

\item{maxit}{max iterations in finding nearest positive matrix}
}
\value{
a matrix with dimension p by p, NPD estimator
}
\description{
This routine calculates the NPD estimator for *covariance* based on Qn
}
\examples{
covNPD(matrix(rnorm(500),100,5)) 
}
