% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glasso_CV.R
\name{robglasso}
\alias{robglasso}
\title{glasso with robust covariance estimations}
\usage{
robglasso(
  data,
  covest = cov,
  rho = 0.1,
  CV = FALSE,
  k = 10,
  grids = 15,
  evaluation = negLLrobOmega,
  ...
)
}
\arguments{
\item{data}{raw data, should be a matrix or a data.frame, row as sample}

\item{covest}{a *function* or name of a function (string) that takes a matrix to estimate covariance}

\item{rho}{a scalar or vector of tuning parameters to be chosen, if CV=FALSE, should be a scalar, if CV=TRUE scalar input will be override and tuning parameter will be chosen based on CV}

\item{CV}{bool, whether doing cross validation for tuning parameter, if set to TRUE and rho is a scalar, the candidate will be chosen automatically by log spacing between 0.01 max covariance and max covariance with number of grids}

\item{k}{fold for cross validation if applicable}

\item{grids}{number of candidate tuning parameters in cross validation}

\item{evaluation}{a *function* or name of a function (string) that takes only two arguments, the estimated *covariance* and the test *covariace*, when NULL, we use negative log likelihood on test sets}

\item{...}{extra argument sent to glasso::glasso}
}
\value{
a glasso return (see ?glasso::glasso), most important one is $X the estimated sparse precision,with an extra entry of tuning parameter lambda
}
\description{
This routine fits glasso using a robust covariance matrix
}
\examples{
robglasso(matrix(rnorm(100),20,5))
}
