% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_lm}
\alias{roll_lm}
\title{Rolling Linear Models}
\usage{
roll_lm(x, y, width, weights = rep(1, width), intercept = TRUE,
  min_obs = width, complete_obs = TRUE, na_restore = FALSE,
  online = TRUE)
}
\arguments{
\item{x}{vector or matrix. Rows are observations and columns are the independent variables.}

\item{y}{vector or matrix. Rows are observations and columns are the dependent variables.}

\item{width}{integer. Window size.}

\item{weights}{vector. Weights for each observation within a window.}

\item{intercept}{logical. Either \code{TRUE} to include or \code{FALSE} to remove the intercept.}

\item{min_obs}{integer. Minimum number of observations required to have a value within a window,
otherwise result is \code{NA}.}

\item{complete_obs}{logical. If \code{TRUE} then rows containing any missing values are removed,
if \code{FALSE} then pairwise is used.}

\item{na_restore}{logical. Should missing values be restored?}

\item{online}{logical. Process observations using an online algorithm.}
}
\value{
A list containing the following components:
\item{coefficients}{A list of objects with the rolling and expanding coefficients for each \code{y}.
An object is the same class and dimension (with an added column for the intercept) as \code{x}.}
\item{r.squared}{A list of objects with the rolling and expanding r-squareds for each \code{y}.
An object is the same class as \code{x}.}
\item{std.error}{A list of objects with the rolling and expanding standard errors for each \code{y}.
An object is the same class and dimension (with an added column for the intercept) as \code{x}.}
}
\description{
A function for computing the rolling and expanding linear models of time-series data.
}
\examples{
n <- 15
x <- rnorm(n)
y <- rnorm(n)
weights <- 0.9 ^ (n:1)

# rolling regressions with complete windows
roll_lm(x, y, width = 5)

# rolling regressions with partial windows
roll_lm(x, y, width = 5, min_obs = 1)

# expanding regressions with partial windows
roll_lm(x, y, width = n, min_obs = 1)

# expanding regressions with partial windows and weights
roll_lm(x, y, width = n, min_obs = 1, weights = weights)
}
