% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-same-factor.R
\name{same_factor}
\alias{same_factor}
\title{Compare Factor Similarity Across Lists}
\usage{
same_factor(
  ...,
  method = c("exact", "order"),
  levels,
  ordered = FALSE,
  digits = 3
)
}
\arguments{
\item{...}{Lists of categorical values (character or factor) to compare}

\item{method}{Character vector of similarity methods. Choose from: "exact",
"order" (default: all)}

\item{levels}{Character vector of all allowed levels for comparison}

\item{ordered}{Logical. If TRUE, treat levels as ordered (ordinal). If FALSE,
the "order" method is skipped.}

\item{digits}{Number of digits to round results (default: 3)}
}
\value{
An S3 object of type "similar_factor" containing:
\itemize{
\item scores: Numeric similarity scores by method and comparison
\item summary: Summary statistics by method and comparison
\item methods: Methods used for comparison
\item list_names: Names of compared lists
\item levels: Levels used for categorical comparison
}
}
\description{
Compare Factor Similarity Across Lists
}
