% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R, R/breaks.R, R/tab.R
\name{chop_n}
\alias{chop_n}
\alias{brk_n}
\alias{tab_n}
\title{Chop into fixed-sized groups}
\usage{
chop_n(x, n, ..., close_end = TRUE, tail = "split")

brk_n(n, tail = "split")

tab_n(x, n, ..., tail = "split")
}
\arguments{
\item{x}{A vector.}

\item{n}{Integer. Number of elements in each interval.}

\item{...}{Passed to \code{\link[=chop]{chop()}}.}

\item{close_end}{Logical. Close last break at right? (If \code{left} is \code{FALSE},
close first break at left?)}

\item{tail}{String. What to do if the final interval has fewer than \code{n} elements?
\code{"split"} to keep it separate. \code{"merge"} to merge it with the neighbouring
interval.}
}
\value{
\verb{chop_*} functions return a \code{\link{factor}} of the same length as \code{x}.

\verb{brk_*} functions return a \code{\link{function}} to create \code{breaks}.

\verb{tab_*} functions return a contingency \code{\link[=table]{table()}}.
}
\description{
\code{chop_n()} creates intervals containing a fixed number of elements.
}
\details{
The algorithm guarantees that intervals contain no more than \code{n} elements, so
long as there are no duplicates in \code{x} and \code{tail = "split"}. It also
guarantees that intervals contain no fewer than \code{n} elements, except possibly
the last interval (or first interval if \code{left} is \code{FALSE}).

To ensure that all intervals contain at least \code{n} elements (so long as there
are at least \code{n} elements in \code{x}!) set \code{tail = "merge"}.

If \code{tail = "split"} and there are intervals containing duplicates with more
than \code{n} elements, a warning is given.
}
\examples{
chop_n(1:10, 5)

chop_n(1:5, 2)
chop_n(1:5, 2, tail = "merge")

# too many duplicates
x <- rep(1:2, each = 3)
chop_n(x, 2)

tab_n(1:10, 5)

# fewer elements in one group
tab_n(1:10, 4)

}
\seealso{
Other chopping functions: 
\code{\link{chop}()},
\code{\link{chop_equally}()},
\code{\link{chop_evenly}()},
\code{\link{chop_fn}()},
\code{\link{chop_mean_sd}()},
\code{\link{chop_proportions}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_width}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
