% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Seurat_Iterative.R
\name{Iterate_PC_Loading_Plots}
\alias{Iterate_PC_Loading_Plots}
\title{Iterate PC Loading Plots}
\usage{
Iterate_PC_Loading_Plots(
  seurat_object,
  dims_plot = NULL,
  file_path = NULL,
  name_prefix = NULL,
  file_name = "PC_Loading_Plots.pdf",
  return_plots = FALSE
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{dims_plot}{number of PCs to plot (integer).  Default is all dims present in PCA.}

\item{file_path}{directory file path to save file.}

\item{name_prefix}{prefix for file name (optional).}

\item{file_name}{suffix for file name.  Default is "PC_Loading_Plots".}

\item{return_plots}{Whether to return the plot list (Default is FALSE).  Must assign to environment
to save plot list.}
}
\value{
A list of plots outputted as pdf
}
\description{
Plot PC Heatmaps and Dim Loadings for exploratory analysis
}
\examples{
\dontrun{
Iterate_PC_Loading_Plots(seurat_object = seurat, dims_plot = 25, file_path = "plots/")
}

}
\seealso{
\code{\link[Seurat]{PCHeatmap}} and \code{\link[Seurat]{VizDimLoadings}}
}
\concept{iterative_plotting}
