% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplm.R, R/print-export-mplm.R
\name{mplm}
\alias{mplm}
\alias{print.sc_mplm}
\alias{export.sc_mplm}
\title{Multivariate Piecewise linear model / piecewise regression}
\usage{
mplm(
  data,
  dvar,
  mvar,
  pvar,
  model = c("W", "H-M", "B&L-B", "JW"),
  contrast = c("first", "preceding"),
  contrast_level = c(NA, "first", "preceding"),
  contrast_slope = c(NA, "first", "preceding"),
  trend = TRUE,
  level = TRUE,
  slope = TRUE,
  formula = NULL,
  update = NULL,
  na.action = na.omit,
  ...
)

\method{print}{sc_mplm}(x, digits = "auto", std = FALSE, ...)

\method{export}{sc_mplm}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  nice = TRUE,
  std = FALSE,
  decimals = 2,
  ...
)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{model}{Model used for calculating the dummy parameters (see Huitema &
McKean, 2000). Default is \code{model = "W"}. Possible values are: \code{"B&L-B"},
\code{"H-M"}, \code{"W"}, and deprecated \code{"JW"}.}

\item{contrast}{Sets contrast_level and contrast_slope. Either "first",
"preceding" or a contrast matrix.}

\item{contrast_level}{Either "first", "preceding" or a contrast matrix. If NA
contrast_level is a copy of contrast.}

\item{contrast_slope}{Either "first", "preceding" or a contrast matrix. If NA
contrast_level is a copy of contrast.}

\item{trend}{A logical indicating if a trend parameters is included in the
model.}

\item{level}{A logical indicating if a level parameters is included in the
model.}

\item{slope}{A logical indicating if a slope parameters is included in the
model.}

\item{formula}{Defaults to the standard piecewise regression model. The
parameter phase followed by the phase name (e.g., \code{phaseB}) indicates the
level effect of the corresponding phase. The parameter 'inter' followed by
the phase name (e.g., \code{interB}) adresses the slope effect based on the
method provide in the model argument (e.g., \code{"B&L-B"}). The formula can be
changed for example to include further variables into the regression model.}

\item{update}{An easier way to change the regression formula (e.g., \code{. ~ . + newvariable}).}

\item{na.action}{Defines how to deal with missing values.}

\item{...}{Further arguments passed to the \code{\link[=lm]{lm()}} function.}

\item{x}{Object returned from \code{\link[=mplm]{mplm()}}.}

\item{digits}{The minimum number of significant digits to be use.
If set to "auto" (default), values are predefined.}

\item{std}{If TRUE, a table with standardized estimates is included.}

\item{object}{An scdf or an object exported from a scan function.}

\item{caption}{Character string with table caption. If left NA (default) a
caption will be created based on the exported object.}

\item{footnote}{Character string with table footnote. If left NA (default) a
footnote will be created based on the exported object.}

\item{filename}{String containing the file name. If a filename is given the
output will be written to that file.}

\item{nice}{If set TRUE (default) output values are rounded and optimized for
publication tables.}

\item{decimals}{Decimal places that are reported.}
}
\value{
\tabular{ll}{
    \tab  \cr
   \code{model} \tab Character string from function call (see arguments above). \cr
   \code{contrast} \tab List with contrast definitions. \cr
   \code{full.model} \tab Full regression model list. \cr
   \code{formula} \tab Formula of the mplm model. \cr
}
}
\description{
The \code{\link[=mplm]{mplm()}} function computes a multivariate piecewise regression model.
}
\section{Functions}{
\itemize{
\item \code{print(sc_mplm)}: Print results

\item \code{export(sc_mplm)}: Export results as html

}}
\examples{
res <- mplm(Leidig2018$`1a1`,
  dvar = c("academic_engagement", "disruptive_behavior")
)
print(res)
## also report standardized coefficients:
print(res, std = TRUE)
}
\seealso{
Other regression functions: 
\code{\link{autocorr}()},
\code{\link{bplm}()},
\code{\link{corrected_tau}()},
\code{\link{hplm}()},
\code{\link{plm}()},
\code{\link{trend}()}
}
\author{
Juergen Wilbert
}
\concept{regression functions}
