% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{fac2col}
\alias{fac2col}
\title{Utility function to translate a factor into colors}
\usage{
fac2col(
  x,
  s = 1,
  v = 1,
  shuffle = FALSE,
  min.group.size = 1,
  return.details = FALSE,
  unclassified.cell.color = "gray50",
  level.colors = NULL
)
}
\arguments{
\item{x}{input factor}

\item{s}{numeric The "saturation" to be used to complete the HSV color descriptions (default=1) See ?rainbow in Palettes, grDevices}

\item{v}{numeric The "value" to be used to complete the HSV color descriptions (default=1) See ?rainbow in Palettes, grDevices}

\item{shuffle}{boolean If TRUE, shuffles columns with shuffle(columns) (default=FALSE)}

\item{min.group.size}{integer Exclude groups of size less than the min.group.size (default=1)}

\item{return.details}{boolean If TRUE, returns a list list(colors=y, palette=col). Otherwise, just returns the factor (default=FALSE)}

\item{unclassified.cell.color}{Color for unclassified cells (default='gray50')}

\item{level.colors}{(default=NULL)}
}
\value{
vector or list of colors
}
\description{
Utility function to translate a factor into colors
}
\examples{
genes = factor(c("BRAF", "NPC1", "PAX3", "BRCA2", "FMR1"))
fac2col(genes)

}
