% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_embedding.R
\name{graphToAdjList}
\alias{graphToAdjList}
\title{Convert igraph graph into an adjacency list}
\usage{
graphToAdjList(graph)
}
\arguments{
\item{graph}{input igraph object}
}
\value{
adjacency list, defined by list(idx=adj.list, probabilities=probs, names=edge.list.fact$levels
}
\description{
Convert igraph graph into an adjacency list
}
\examples{
library(dplyr)
edge.list.fact <- igraph::as_edgelist(conosGraph) \%>\% as_factor()
edge.list <- matrix(edge.list.fact$values, ncol=2)
n.nodes <- length(igraph::V(conosGraph))
splitVectorByNodes(edge.list[,1], edge.list[,2], n.nodes)

}
