% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin_ply}
\alias{woebin_ply}
\title{WOE Transformation}
\usage{
woebin_ply(dt, bins, no_cores = NULL, print_step = 0L)
}
\arguments{
\item{dt}{A data frame.}

\item{bins}{Binning information generated from \code{woebin}.}

\item{no_cores}{Number of CPU cores for parallel computation. Defaults NULL. If no_cores is NULL, the no_cores will set as 1 if length of x variables less than 10, and will set as the number of all CPU cores if the length of x variables greater than or equal to 10.}

\item{print_step}{A non-negative integer. Default is 1. If print_step>0, print variable names by each print_step-th iteration. If print_step=0 or no_cores>1, no message is print.}
}
\value{
Binning information
}
\description{
\code{woebin_ply} converts original input data into woe values based on the binning information generated from \code{woebin}.
}
\examples{
# load germancredit data
data(germancredit)

# Example I
dt = germancredit[, c("creditability", "credit.amount", "purpose")]

# binning for dt
bins = woebin(dt, y = "creditability")

# converting original value to woe
dt_woe = woebin_ply(dt, bins=bins)
str(dt_woe)

\dontrun{
# Example II
# binning for germancredit dataset
bins_germancredit = woebin(germancredit, y="creditability")

# converting the values in germancredit to woe
# bins is a list which generated from woebin()
germancredit_woe = woebin_ply(germancredit, bins_germancredit)

# bins is a dataframe
bins_df = data.table::rbindlist(bins_germancredit)
germancredit_woe = woebin_ply(germancredit, bins_df)
}

}
\seealso{
\code{\link{woebin}}, \code{\link{woebin_plot}}, \code{\link{woebin_adj}}
}
