% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-quantile.R
\name{bias_quantile}
\alias{bias_quantile}
\title{Determines bias of quantile forecasts}
\usage{
bias_quantile(observed, predicted, quantile_level, na.rm = TRUE)
}
\arguments{
\item{observed}{Numeric vector of size n with the observed values.}

\item{predicted}{Numeric nxN matrix of predictive
quantiles, n (number of rows) being the number of forecasts (corresponding
to the number of observed values) and N
(number of columns) the number of quantiles per forecast.
If \code{observed} is just a single number, then predicted can just be a
vector of size N.}

\item{quantile_level}{Vector of of size N with the quantile levels
for which predictions were made. Note that if this does not contain the
median (0.5) then the median is imputed as being the mean of the two
innermost quantiles.}

\item{na.rm}{Logical. Should missing values be removed?}
}
\value{
scalar with the quantile bias for a single quantile prediction
}
\description{
Determines bias from quantile forecasts. For an increasing number of
quantiles this measure converges against the sample based bias version
for integer and continuous forecasts.
}
\details{
For quantile forecasts, bias is measured as

\deqn{
B_t = (1 - 2 \cdot \max \{i | q_{t,i} \in Q_t \land q_{t,i} \leq x_t\})
 \mathbf{1}( x_t \leq q_{t, 0.5}) \\
+ (1 - 2 \cdot \min \{i | q_{t,i} \in Q_t \land q_{t,i} \geq x_t\})
 1( x_t \geq q_{t, 0.5}),}

where \eqn{Q_t} is the set of quantiles that form the predictive
distribution at time \eqn{t} and \eqn{x_t} is the observed value. For
consistency, we define \eqn{Q_t} such that it always includes the element
\eqn{q_{t, 0} = - \infty} and \eqn{q_{t,1} = \infty}.
\eqn{1()} is the indicator function that is \eqn{1} if the
condition is satisfied and \eqn{0} otherwise.

In clearer terms, bias \eqn{B_t} is:
\itemize{
\item \eqn{1 - 2 \cdot} the maximum percentile rank for which the corresponding
quantile is still smaller than or equal to the observed value,
\emph{if the observed value is smaller than the median of the predictive
distribution.}
\item \eqn{1 - 2 \cdot} the minimum percentile rank for which the corresponding
quantile is still larger than or equal to the observed value \emph{if the observed
value is larger
than the median of the predictive distribution.}.
\item \eqn{0} \emph{if the observed value is exactly the median} (both terms cancel
out)
}

Bias can assume values between -1 and 1 and is 0 ideally (i.e. unbiased).

Note that if the given quantiles do not contain the median, the median is
imputed as a linear interpolation of the two innermost quantiles. If the
median is not available and cannot be imputed, an error will be thrown.
Note that in order to compute bias, quantiles must be non-decreasing with
increasing quantile levels.

For a large enough number of quantiles, the
percentile rank will equal the proportion of predictive samples below the
observed value, and the bias metric coincides with the one for
continuous forecasts (see \code{\link[=bias_sample]{bias_sample()}}).
}
\section{Input format}{
\if{html}{
  \out{<div style="text-align: left">}
  \figure{metrics-quantile.png}{options: style="width:750px;max-width:100\%;"}
  \out{</div><p>}
  Overview of required input format for quantile-based forecasts
}
\if{latex}{
  \figure{metrics-quantile.png}
}
}

\examples{
predicted <- matrix(c(1.5:23.5, 3.3:25.3), nrow = 2, byrow = TRUE)
quantile_level <- c(0.01, 0.025, seq(0.05, 0.95, 0.05), 0.975, 0.99)
observed <- c(15, 12.4)
bias_quantile(observed, predicted, quantile_level)
}
\keyword{metric}
