% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-quantile.R
\name{interpolate_median}
\alias{interpolate_median}
\title{Helper function to interpolate the median prediction if it is not available}
\usage{
interpolate_median(predicted, quantile_level)
}
\arguments{
\item{predicted}{Vector of length N (corresponding to the number of
quantiles) that holds predictions.}

\item{quantile_level}{Vector of of size N with the quantile levels
for which predictions were made. Note that if this does not contain the
median (0.5) then the median is imputed as being the mean of the two
innermost quantiles.}
}
\value{
scalar with the imputed median prediction
}
\description{
Internal function to interpolate the median prediction if it is not
available in the given quantile levels.
This is done using linear interpolation between the two innermost quantiles.
}
\section{Input format}{
\if{html}{
  \out{<div style="text-align: left">}
  \figure{metrics-quantile.png}{options: style="width:750px;max-width:100\%;"}
  \out{</div><p>}
  Overview of required input format for quantile-based forecasts
}
\if{latex}{
  \figure{metrics-quantile.png}
}
}

\keyword{internal}
