% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipboard.R
\name{save_bmp}
\alias{save_bmp}
\title{Save an image as a BMP file}
\usage{
save_bmp(image_data, path)
}
\arguments{
\item{image_data}{A raster image data object, such as an array
of pixel values or an R object representing an image.}

\item{path}{The path to the file to be saved.}
}
\value{
Saves the image as a BMP file at the specified path.
}
\description{
Save an image as a BMP file
}
\examples{
\dontrun{
# Create an image data object
image_data <- matrix(rnorm(100), ncol = 10)
# Save the image as a BMP file
save_bmp(image_data, "image.bmp")
}

}
