% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rscripts.R
\name{gcount_to_gvec}
\alias{gcount_to_gvec}
\title{Converts genotype counts to genotype vectors.}
\usage{
gcount_to_gvec(gcount)
}
\arguments{
\item{gcount}{The vector of genotype counts.}
}
\value{
A vector of length \code{sum(gcount)}, containing \code{gcount[1]}
copies of \code{0}, \code{gcount[2]} copies of \code{1}, \code{gcount[3]}
copies of \code{2}, etc.
}
\description{
Converts genotype counts to genotype vectors.
}
\examples{
gcount <- c(1, 2, 3, 0, 5)
gcount_to_gvec(gcount = gcount)
}
\seealso{
\code{\link[=gvec_to_gcount]{gvec_to_gcount()}}
}
\author{
David Gerard
}
