% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_youden_plot.R
\name{draw_youden_plot}
\alias{draw_youden_plot}
\title{Draw Youden Plot}
\usage{
draw_youden_plot(
  data,
  x_axis_var,
  y_axis_var,
  grouping_var,
  lsl,
  usl,
  median_line = FALSE,
  size = 2,
  alpha = 0.4,
  analysis_desc_label = NULL,
  x_axis_label = NULL,
  y_axis_label = NULL
)
}
\arguments{
\item{data}{input dataset to be plotted (required)}

\item{x_axis_var}{variable to be plotted on x axis (required)}

\item{y_axis_var}{variable to be plotted on x axis (required)}

\item{grouping_var}{grouping variable (optional)}

\item{lsl}{lower specification limit (optional)}

\item{usl}{upper specification limit (optional)}

\item{median_line}{logical. If TRUE, a median bias line is plotted. By default, it is set to FALSE  (optional)}

\item{size}{Set point size. By default, it is set to 2  (optional)}

\item{alpha}{Set transparency. By default, it is set to 0.4  (optional)}

\item{analysis_desc_label}{Label (subtitle) for analysis description. By default, it is set to NULL  (optional)}

\item{x_axis_label}{Label for x axis. By default, it is set to display x axis column name  (optional)}

\item{y_axis_label}{Label for y axis. By default, it is set to display y axis column name  (optional)}
}
\value{
A 'ggplot' object
}
\description{
Draws a Youden Plot
}
\examples{
youden_plot_data \%>\%
    draw_youden_plot(x_axis_var   = measurement_1,
                     y_axis_var   = measurement_2,
                     grouping_var = location)

youden_plot_data_2 \%>\%
    draw_youden_plot(x_axis_var  = gage_1,
                     y_axis_var  = gage_2,
                     median_line = TRUE)

}
