% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simGPR.R
\name{simGPR}
\alias{simGPR}
\title{Simulate Data for Gaussian Process Regression}
\usage{
simGPR(
  N = 200,
  d = 3,
  d_mean = 0,
  sigma2 = 0.1,
  tau = 2,
  kernel_func = kernel_se,
  perc_spars = 0.5,
  theta,
  beta,
  device
)
}
\arguments{
\item{N}{Positive integer specifying the number of observations to simulate. Default is 200.}

\item{d}{Positive integer specifying the number of covariates for the covariance structure. Default is 3.}

\item{d_mean}{Positive integer specifying the number of covariates for the mean structure. Default is 0.}

\item{sigma2}{Positive numeric value specifying the noise variance. Default is 0.1.}

\item{tau}{Positive numeric value specifying the global shrinkage parameter. Default is 2.}

\item{kernel_func}{Function specifying the covariance kernel. Default is \code{kernel_se}.}

\item{perc_spars}{Numeric value in [0, 1] indicating the proportion of elements in \code{theta}
and \code{beta} to sparsify. Default is 0.5.}

\item{theta}{\emph{Optional} numeric vector specifying the true inverse length-scale parameters.
If not provided, they are randomly generated.}

\item{beta}{\emph{Optional} numeric vector specifying the true regression coefficients for the mean
structure. If not provided, they are randomly generated.}

\item{device}{\emph{Optional} \code{torch_device} object specifying whether to run the simulation
on CPU or GPU. Defaults to GPU if available.}
}
\value{
A list containing:
\itemize{
\item \code{data}: A data frame with \code{y} (response variable), \code{x} (covariates for the covariance structure),
and optionally \code{x_mean} (covariates for the mean structure).
\item \code{true_vals}: A list containing the true values used for the simulation:
\itemize{
\item \code{theta}: The true inverse length-scale parameters.
\item \code{sigma2}: The true noise variance.
\item \code{tau}: The true global shrinkage parameter.
\item \code{beta} (optional): The true regression coefficients for the mean structure.
}
}
}
\description{
\code{simGPR} generates simulated data for Gaussian Process Regression (GPR) models, including the true hyperparameters used for simulation.
}
\details{
This function simulates data from a Gaussian Process Regression model.
The response variable \code{y} is sampled from a multivariate normal distribution with
a covariance matrix determined by the specified kernel function, \code{theta}, \code{tau},
and \code{sigma2}. If \code{d_mean > 0}, a mean structure is included in the simulation, with
covariates \code{x_mean} and regression coefficients \code{beta}.
}
\examples{
if (torch::torch_is_installed()) {
  torch::torch_manual_seed(123)

  # Simulate data with default settings
  sim_data <- simGPR()

  # Simulate data with custom settings
  sim_data <- simGPR(N = 100, d = 5, d_mean = 2, perc_spars = 0.3, sigma2 = 0.5)

  # Access the simulated data
  head(sim_data$data)

  # Access the true values used for simulation
  sim_data$true_vals
  }
}
