% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_sf.R
\name{gg_sf_facet}
\alias{gg_sf_facet}
\title{Simple feature ggplot map that is facetted.}
\usage{
gg_sf_facet(
  data,
  facet_var,
  text_var = NULL,
  size_point = 1,
  size_line = 0.5,
  alpha = 0.9,
  pal = NULL,
  facet_labels = stringr::str_to_sentence,
  facet_na = TRUE,
  facet_ncol = NULL,
  facet_nrow = NULL,
  borders = NULL,
  borders_behind = TRUE,
  pal_borders = "#7F7F7FFF",
  borders_size = 0.2,
  title = NULL,
  title_wrap = 100,
  subtitle = NULL,
  subtitle_wrap = 100,
  caption = NULL,
  caption_wrap = 80,
  font_family = "",
  font_size_title = NULL,
  font_size_body = NULL
)
}
\arguments{
\item{data}{A sf object with defined coordinate reference system. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{text_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot, tooltip = "text"). Defaults to NULL.}

\item{size_point}{Size of points. Defaults to 0.5.}

\item{size_line}{Size of lines. Defaults to 0.5.}

\item{alpha}{The alpha of the fill. Defaults to 0.9.}

\item{pal}{Character vector of hex codes.}

\item{facet_labels}{A function or named vector to modify facet scale labels. Defaults to converting labels to sentence case. Use ggplot2::waiver() to keep facet labels untransformed.}

\item{facet_na}{TRUE or FALSE of whether to include facet_var NA values. Defaults to TRUE.}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{borders}{A sf object as administrative boundaries (or coastlines). Defaults to no boundaries added. The rnaturalearth package is a useful source of country and state boundaries.}

\item{borders_behind}{TRUE or FALSE  as to whether the borders is to be behind the sf object defined in the data argument. Defaults to TRUE.}

\item{pal_borders}{Colour of the borders. Defaults to "#7F7F7F".}

\item{borders_size}{Size of the borders. Defaults to 0.2.}

\item{title}{Title string. Defaults to NULL.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 100.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 100.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{font_family}{Font family to use. Defaults to "".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}
}
\value{
A ggplot object.
}
\description{
Map of simple features in ggplot that is facetted, but not coloured.
}
\examples{
gg_sf_facet(example_sf_point, 
            facet_var = trend_category, 
            borders = nz)

}
