% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{sv_numeric_breaks_v}
\alias{sv_numeric_breaks_v}
\title{Calculate the breaks for a y axis numeric vector.}
\usage{
sv_numeric_breaks_v(
  var_vctr,
  balance = FALSE,
  pretty_n = 5,
  trans = "identity",
  zero = TRUE
)
}
\arguments{
\item{var_vctr}{A numeric vector for the vertical scale from which to determine breaks from.}

\item{balance}{Add balance to the vertical axis so that zero is in the centre of the vertical scale.}

\item{pretty_n}{The desired number of intervals on the vertical axis, as calculated by the pretty algorithm. Defaults to 5.}

\item{trans}{A string specifying a transformation for the vertical axis scale, such as "log10" or "sqrt". Defaults to "identity".}

\item{zero}{TRUE or FALSE of whether the minimum of the vertical scale is zero. Defaults to TRUE.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to NULL.}
}
\value{
A vector of breaks
}
\description{
Calculate the breaks for a y axis numeric vector.
}
\keyword{internal}
