% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{butterflies}
\alias{butterflies}
\title{butterflies}
\format{
A 'list': List of 3.
\describe{
\item{env}{data.frame with 4 environmental covariates}
\item{PA}{Presence-absence data for 55 butterfly species}
\item{lat_lon}{Coordinates for the sites}
}
}
\source{
\doi{10.1111/2041-210X.13106}
}
\usage{
butterflies
}
\description{
This dataset is from \doi{10.1111/2041-210X.13106}.
}
\details{
This is a dataset about butterfly communities. It consists of 2609 sites and 55 species.
}
\examples{
\dontrun{
  PA = butterflies$PA
  E = butterflies$env
  LatLon = butterflies$lat_lon
  
  m = sjSDM(PA, 
            scale(E), 
            spatial = DNN(scale(LatLon), formula = ~0+.), 
            se = TRUE,
            iter = 20L, # increase to 100
            step_size = 200L,
            verbose = FALSE)
  summary(m)
  plot(m)

}
}
\author{
Maximilian Pichler
}
\keyword{datasets}
