# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' dist_wlatlng_cpp
#'
#' @description
#'
#'  calculate distance between coordinate1<lat1, lng1> and coordinate2<lat2, lng2>
#'
#' @details
#'
#'  calculate the great circle distance between 2 points with Haversine formula,
#'  which deliberately ignores elevation differences.
#'
#'  Haversine formula (from R.W. Sinnott, "Virtues of the Haversine",
#'  Sky and Telescope, vol. 68, no. 2, 1984, p. 159):
#'
#'  dlon = lon2 - lon1
#'
#'  dlat = lat2 - lat1
#'
#'  a = sin^2(dlat/2) + cos(lat1) * cos(lat2) * sin^2(dlon/2)
#'
#'  c = 2 * arcsin(min(1,sqrt(a)))
#'
#'  d = R * c
#'
#' @param lat1 latitude of coordinate1
#'
#' @param lng1 longitude of coordinate1
#'
#' @param lat2 latitude of coordinate2
#'
#' @param lng2 longitude of coordinate2
#'
#' @param measure "mi" (mile) or "km" (kilometer)
#'
#' @name dist_wlatlng_cpp
NULL

#' @details
#'  dist_wlatlng_mi_cpp:
#'
#'   calculate distance between coordinate1<lat1, lng1> and coordinate2<lat2, lng2> in mile
#' @rdname dist_wlatlng_cpp
dist_wlatlng_mi_cpp <- function(lat1, lng1, lat2, lng2) {
    .Call('skm_dist_wlatlng_mi_cpp', PACKAGE = 'skm', lat1, lng1, lat2, lng2)
}

#' @details
#'  dist_wlatlng_km_cpp:
#'
#'   calculate distance between coordinate1<lat1, lng1> and coordinate2<lat2, lng2> in kilometer
#' @rdname dist_wlatlng_cpp
dist_wlatlng_km_cpp <- function(lat1, lng1, lat2, lng2) {
    .Call('skm_dist_wlatlng_km_cpp', PACKAGE = 'skm', lat1, lng1, lat2, lng2)
}

#' @details
#'  distSgl_wlatlng_cpp:
#'
#'   calculate distance between coordinate1<lat1, lng1> and coordinate2<lat2, lng2> in
#'   mile (measure = "mi") or kilometer (measure = "km"), default is mile.
#'
#'   implement as serial computing over vector of lat1, lng1, lat2, lng2
#' @rdname dist_wlatlng_cpp
distSgl_wlatlng_cpp <- function(lat1, lng1, lat2, lng2, measure = "mi") {
    .Call('skm_distSgl_wlatlng_cpp', PACKAGE = 'skm', lat1, lng1, lat2, lng2, measure)
}

#' @details
#'  distRpl_wlatlng_cpp:
#'
#'   calculate distance between coordinate1<lat1, lng1> and coordinate2<lat2, lng2> in
#'   mile (measure = "mi") or kilometer (measure = "km"), default is mile.
#'
#'   implement as parallel computing over vector of lat1, lng1, lat2, lng2 via RcppParallel
#' @param distRpl_GS The grain size of a parallel algorithm sets a minimum chunk size for parallelization.
#'  In other words, at what point to stop processing input on separate threads (as sometimes creating more
#'  threads can degrade the performance of an algorithm by introducing excessive synchronization overhead).
#'  Default is 100.
#' @rdname dist_wlatlng_cpp
distRpl_wlatlng_cpp <- function(lat1, lng1, lat2, lng2, measure = "mi", distRpl_GS = 100L) {
    .Call('skm_distRpl_wlatlng_cpp', PACKAGE = 'skm', lat1, lng1, lat2, lng2, measure, distRpl_GS)
}

#' col_min_idx
#' @description
#'  calculate colvec min value index within limited range
#' @param u
#'  u: a numeric colvec
#' @param wlmt
#'  wlmt: limit search on colvec on indices within wlmt
#' @return id
#'  an index of min value in u within wlmt w.r.t to original index
#' @note
#'   cpp use index start from 0 vs r use index start from 1
#' @note
#'   in case of equal std:min/std:max take first index seen
#' @family matrix_minmax
#' @export
col_min_idx <- function(u, wlmt) {
    .Call('skm_col_min_idx', PACKAGE = 'skm', u, wlmt)
}

#' col_max_idx
#' @description
#'  calculate colvec max value index within limited range
#' @inheritParams col_min_idx
#' @return id
#'  an index of max value in u within wlmt w.r.t to original index
#' @note
#'  cpp use index start from 0 vs r use index start from 1
#' @note
#'  in case of equal std:min/std:max take first index seen
#' @family matrix_minmax
#' @export
col_max_idx <- function(u, wlmt) {
    .Call('skm_col_max_idx', PACKAGE = 'skm', u, wlmt)
}

#' col_min_val
#' @description
#'  calculate colvec min value within limited range
#' @inheritParams col_min_idx
#' @return vd
#'  min value in u within wlmt w.r.t to original index
#' @family matrix_minmax
#' @export
col_min_val <- function(u, wlmt) {
    .Call('skm_col_min_val', PACKAGE = 'skm', u, wlmt)
}

#' col_max_val
#' @description
#'  calculate colvec max value within limited range
#' @inheritParams col_min_idx
#' @return vd
#'  min value in u within wlmt w.r.t to original index
#' @family matrix_minmax
#' @export
col_max_val <- function(u, wlmt) {
    .Call('skm_col_max_val', PACKAGE = 'skm', u, wlmt)
}

#' col_rgn_val
#' @description
#'  calculate colvec range = max - min value within limited range
#' @inheritParams col_min_idx
#' @return vd
#'  max - min value in u within wlmt w.r.t to original index
#' @family matrix_minmax
#' @export
col_rgn_val <- function(u, wlmt) {
    .Call('skm_col_rgn_val', PACKAGE = 'skm', u, wlmt)
}

#' stratified_sampling
#' @description
#'  select k elements from vector v w.r.t stratify structure group g.
#'  TODO - implementing via template so v is flexible as vec or uvec.
#' @param v <vector>
#'  v: a numeric candidate v from which draw sample.
#' @param k <integer>
#'  k: selection sample size.
#' @param g <vector>
#'  g: stratify structure g - info on grouping of v so that the selected sample is stratified across groups.
#' @return s <vector>
#'  s: a vector select from v length k stratified by g.
#' @note
#'  v is required as an integer vector for using in skm
#' @export
stratified_sampling <- function(v, k, g) {
    .Call('skm_stratified_sampling', PACKAGE = 'skm', v, k, g)
}

skm_mlp_cpp <- function(x, k, s_must, max_it, max_at) {
    .Call('skm_skm_mlp_cpp', PACKAGE = 'skm', x, k, s_must, max_it, max_at)
}

skm_mls_cpp <- function(x, k, g, s_must, max_it, max_at) {
    .Call('skm_skm_mls_cpp', PACKAGE = 'skm', x, k, g, s_must, max_it, max_at)
}

skmRpl_mlp_cpp <- function(x, k, s_must, max_it, max_at, skmRpl_GS = 100L) {
    .Call('skm_skmRpl_mlp_cpp', PACKAGE = 'skm', x, k, s_must, max_it, max_at, skmRpl_GS)
}

#' skm_gdp_cpp
#' @description
#'  solve selective kmeans via a greedy propagation.
#' @details
#' skm_gdp_cpp init with an input m x n matrix x and want to select an index set s
#'  of size k from x row index started from 0 such that
#'
#'  minimize sum(min(x.subview(i in s, all j), min over all i), sum over all j)
#'
#' skm_gdp_cpp solve the problem with greedy propagation via selecting the current
#'  best addon index from the index set left, addon index is defined as such index
#'  when addon to the selected one can bring the most improvement.
#'
#' since skm_gbp_cpp would select index one by one, and no return, e.g., if select
#'  index A for k = 1, then selection on k = 2 would build on k = 1, so index A is
#'  always present in the solution, so all index can be ranked w.r.t when it would
#'  be considered as the best addon.
#' as a result skm_gbp_cpp a parameter k is not always required, so default k = 0
#'  will resturn a vector of size m, and user can select to top k as solution for k.
#' @param x
#'  an m x n matrix of s - t - dist
#' @param k
#'  number of index to be selected from x row index start from 0.
#' @return s
#'  a ranked index 0 - m - 1 where the top k would
#'   minimize sum(min(x.subview(i in s(0..k-1), all j), min over all i), sum over all j)
#' @family skm_gdp
#' @export
skm_gdp_cpp <- function(x, k = 0L) {
    .Call('skm_skm_gdp_cpp', PACKAGE = 'skm', x, k)
}

