% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slasso-package.R
\docType{package}
\name{slasso-package}
\alias{slasso}
\alias{slasso-package}
\title{Smooth LASSO Estimator for the Function-on-Function Linear Regression Model}
\description{
Implements the Smooth LASSO Estimator for the Function-on-Function Linear Regression Model described in Centofanti et al. (2020) <arXiv:2007.00529>.
}
\details{
\tabular{ll}{
Package: \tab slasso\cr
Type: \tab Package\cr
Version: \tab 1.0.0 \cr
Date: \tab  2021-10-13 \cr
License: \tab GPL (>= 3)\cr
}
}
\examples{
\donttest{
library(slasso)
data<-simulate_data("Scenario II",n_obs=150)
X_fd=data$X_fd
Y_fd=data$Y_fd
domain=c(0,1)
n_basis_s<-30
n_basis_t<-30
breaks_s<-seq(0,1,length.out = (n_basis_s-2))
breaks_t<-seq(0,1,length.out = (n_basis_t-2))
basis_s <- fda::create.bspline.basis(domain,breaks=breaks_s)
basis_t <- fda::create.bspline.basis(domain,breaks=breaks_t)

mod_slasso_cv<-slasso.fr_cv(Y_fd = Y_fd,X_fd=X_fd,basis_s=basis_s,basis_t=basis_t,
lambda_L_vec = 10^seq(0,1,by=1),lambda_s_vec = 10^-9,lambda_t_vec = 10^-7,
B0=NULL,max_iterations=10,K=2,invisible=1,ncores=1)
mod_slasso<-slasso.fr(Y_fd = Y_fd,X_fd=X_fd,basis_s=basis_s,basis_t=basis_t,
lambda_L = 10^0.7,lambda_s =10^-5,lambda_t = 10^-6,B0 =NULL,invisible=1,max_iterations=10)

plot(mod_slasso_cv)
plot(mod_slasso)
}
}
\references{
Centofanti, F., Fontana, M., Lepore, A., & Vantini, S. (2020).
Smooth LASSO Estimator for the Function-on-Function Linear Regression Model.
\emph{arXiv preprint arXiv:2007.00529}.
}
\seealso{
\code{\link{slasso.fr}},  \code{\link{slasso.fr_cv}}
}
\author{
Fabio Centofanti, Matteo Fontana, Antonio Lepore, Simone Vantini
}
