% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_soils_data}
\alias{get_soils_data}
\title{Get SLGA soils data}
\usage{
get_soils_data(
  product = NULL,
  attribute = NULL,
  component = "ALL",
  depth = NULL,
  aoi = NULL,
  write_out = FALSE,
  filedir
)
}
\arguments{
\item{product}{Character, one of the options from column 'Short_Name' in
\code{\link[slga:slga_product_info]{slga_product_info}}, where Type =
'Soil'.}

\item{attribute}{Character, one of the options from column 'Code' in
\code{\link[slga:slga_attribute_info]{slga_attribute_info}}.}

\item{component}{Character, one of the following:
\itemize{
 \item 'VAL' - predicted value surface.
 \item 'CLO' - lower 95\% confidence interval surface.
 \item 'CHI' - upper 95\% confidence interval surface.
 \item 'CIS' - both confidence interval surfaces.
 \item 'ALL' - value and both confidence interval surfaces.
 }
 Defaults to 'ALL'.}

\item{depth}{Integer from 1 to 6. The numbers correspond to the
 following depth ranges:
\enumerate{
 \item 0 to 5 cm.
 \item 5 to 15 cm.
 \item 15 to 30 cm.
 \item 30 to 60 cm.
 \item 60 to 100 cm.
 \item 100 to 200 cm.
 }}

\item{aoi}{Vector of WGS84 coordinates defining a rectangular area of
interest. The vector may be specified directly in the order xmin, ymin,
xmax, ymax, or the function can derive an aoi from the boundary of an `sf`
or `raster` object.}

\item{write_out}{Boolean, whether to write the retrieved dataset to disk.
Defaults to FALSE.}

\item{filedir}{directory in which to write files if write_out == TRUE.}
}
\value{
Raster stack or single raster, depending on the value of `component`.
}
\description{
Downloads SLGA gridded soils data in raster format from public WCS
services.
}
\note{
\itemize{
  \item An aoi larger than 1x1 decimal degree is retrieveable, but be
  aware that download file size will be large. If you want a dataset that
  covers more than ~3x3', it may be faster to download the full
  GeoTIFF from the CSIRO Data Access Portal and crop out your AOI using GDAL.
  \item Output rasters are aligned to the parent dataset rather than the aoi.
  Further resampling may be required for some applications.
  \item specify `depth = 1` for attributes 'DES' and 'DER' as they are
  whole-of-profile parameters.
  }
}
\examples{
\donttest{
# get surface clay data for central Brisbane
aoi <- c(152.95, -27.55, 153.07, -27.45)
bne_surface_clay <- get_soils_data(product = 'NAT', attribute = 'CLY',
                                   component = 'ALL', depth = 1,
                                   aoi = aoi, write_out = FALSE)

# get estimated clay by depth for central Brisbane
bne_all_clay <- lapply(seq.int(6), function(d) {
  get_soils_data(product = 'NAT', attribute = 'CLY',
                 component = 'VAL', depth = d,
                 aoi = aoi, write_out = FALSE)
})
bne_all_clay <- raster::brick(bne_all_clay)
}
}
