%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-11-08 :05:09.
% Do NOT modify this file, instead modify the source (Rarray.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{stat.gnames}

\alias{stat.gnames}

\title{Sort Genes According to the Value of a Statistic}

\description{
Lists genes and corresponding statistics in decreasing order of the
statistics. This function applies to any type of statistic, including
log ratios, one and two-sample t-statistics, and F-statistics. Missing
values are ignored, as in \code{\link{sort}(..., na.last=NA)}. 
}

\usage{
stat.gnames(x, gnames, crit=0.05)
}

\arguments{
 \item{x}{a numeric vector containing the statistics for each
 gene. Missing values (NAs) are allowed. }
 
\item{gnames}{a character vector containing the gene names.}

 \item{crit}{specifies the number of genes to be returned. If crit <
 1, the crit*100\% genes with the largest x values are listed. If crit
 >= 1, the crit genes with the largest x values are listed. }
}

\value{
List containing the following components 
  \item{gnames}{gene names sorted in decreasing order of the
 statistics in x.}
 \item{t}{statistics sorted in decreasing order.}
}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} }

\seealso{\code{\link{stat.t2}}, \code{\link{order}}, \code{\link{sort}}.}

\examples{
## Calculating log ratio and performing a t test.
data(MouseArray)
## mouse.setup <- init.grid()
## mouse.data <- init.data() ## see \emph{init.data}
mouse.lratio <- stat.ma(mouse.data, mouse.setup)
cl <- c(rep(1,3), rep(2,3))
mouse.t2 <- stat.t2(mouse.lratio, cl)

## Looking at gene names
## Finding the top 10 t-statistics
stat.gnames(abs(mouse.t2$t), mouse.gnames, crit=10)

## Finding the top 1% of t-statistics
stat.gnames(abs(mouse.t2$t), mouse.gnames, crit=0.01)

## Finding the 10 extreme M values in the first slide
stat.gnames(abs(mouse.lratio$M[, 1]), mouse.gnames, crit=10)
}

\keyword{misc}
%\keyword{microarray.}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
