structure(list(method = "GET", url = "https://api.us.socrata.com/api/catalog/v1?limit=10&only=dataset&categories=transportation&categories=economy", 
    status_code = 200L, headers = structure(list(Server = "nginx", 
        Date = "Tue, 22 Jul 2025 20:41:59 GMT", `Content-Type` = "application/json;charset=utf-8", 
        `Transfer-Encoding` = "chunked", Connection = "keep-alive", 
        `Access-Control-Allow-Origin` = "*", Vary = "Accept-Encoding", 
        `Content-Encoding` = "gzip", `X-Socrata-Region` = "aws-us-east-1-fedramp-prod", 
        `Strict-Transport-Security` = "max-age=31536000; includeSubDomains"), class = "httr2_headers"), 
    body = charToRaw("{\n  \"results\" :\n    [\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Vital Signs: Commute Mode Choice (by Place of Residence) – Bay Area\",\n            \"id\" : \"9mau-as85\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"VITAL SIGNS INDICATOR\\nCommute Mode Choice (T1)\\n\\nFULL MEASURE NAME\\nCommute mode share by residential location\\n\\nLAST UPDATED\\nApril 2020\\n\\nDESCRIPTION\\nCommute mode choice, also known as commute mode share, refers to the mode of transportation that a commuter uses to travel to work, such as driving alone, biking, carpooling or taking transit. The dataset includes metropolitan area, regional, county, city and census tract tables by place of residence.\\n\\nDATA SOURCE\\nU.S. Census Bureau: Decennial Census (1960-2000) - via MTC/ABAG Bay Area Census\\nhttp://www.bayareacensus.ca.gov/transportation/Means19802000.htm\\n\\nU.S. Census Bureau: American Community Survey\\nForm B08301 (2006-2018; place of residence)\\nwww.api.census.gov\\n\\nCONTACT INFORMATION\\nvitalsigns.info@bayareametro.gov\\n\\nMETHODOLOGY NOTES (across all datasets for this indicator)\\nFor the decennial Census datasets, the breakdown of auto commuters between drive alone and carpool is not available before 1980. \\\"Other\\\" includes bicycle, motorcycle, taxi, and other modes of transportation.\\n\\nFor the American Community Survey datasets, 1-year rolling average data was used for metros, region, and county geographic levels, while 5-year rolling average data was used for cities and tracts. This is due to the fact that more localized data is not included in the 1-year dataset across all Bay Area cities. Regional mode shares are population-weighted averages of the nine counties’ modal shares. \\\"Auto\\\" includes drive alone and carpool for the simple data tables and is broken out in the detailed data tables accordingly, as it was not available before 1980. “Transit” includes public operators (Muni, BART, etc.) and employer-provided shuttles (e.g., Google shuttle buses). \\\"Other\\\" includes motorcycle, taxi, and other modes of transportation; bicycle mode share was broken out separately for the first time in the 2006 data and is shown in the detailed data tables. Census tract data is not available for tracts with insufficient numbers of residents or workers.\\n\\nThe metropolitan area comparison was performed for the nine-county San Francisco Bay Area in addition to the primary MSAs for the nine other major metropolitan areas.\",\n            \"attribution\" : \"U.S. Census Bureau\",\n            \"attribution_link\" : \"https://data.census.gov\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2020-05-20T21:50:47.000Z\",\n            \"createdAt\" : \"2020-04-09T17:01:10.000Z\",\n            \"metadata_updated_at\" : \"2020-05-20T21:50:47.000Z\",\n            \"data_updated_at\" : \"2020-04-15T20:55:37.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 4,\n                \"page_views_last_month\" : 9,\n                \"page_views_total\" : 467,\n                \"page_views_last_week_log\" : 2.321928094887362,\n                \"page_views_last_month_log\" : 3.3219280948873626,\n                \"page_views_total_log\" : 8.870364719583405\n              },\n            \"columns_name\" :\n              [ \"Mode\", \"Region\", \"Source\", \"Share\", \"Data_Type\", \"Year\" ],\n            \"columns_field_name\" :\n              [ \"mode\", \"region\", \"source\", \"share\", \"data_type\", \"year\" ],\n            \"columns_datatype\" :\n              [ \"Text\", \"Text\", \"Text\", \"Number\", \"Text\", \"Number\" ],\n            \"columns_description\" : [ \"\", \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" : [ {}, {}, {}, {}, {}, { \"noCommas\" : \"true\" } ],\n            \"download_count\" : 57,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2020-04-09T17:07:03.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"transportation\", \"demographics\" ],\n            \"tags\" : [],\n            \"domain_tags\" : [ \"vital signs\" ],\n            \"domain_metadata\" : []\n          },\n        \"metadata\" : { \"domain\" : \"data.bayareametro.gov\" },\n        \"permalink\" : \"https://data.bayareametro.gov/d/9mau-as85\",\n        \"link\" : \"https://data.bayareametro.gov/dataset/Vital-Signs-Commute-Mode-Choice-by-Place-of-Reside/9mau-as85\",\n        \"owner\" :\n          {\n            \"id\" : \"wg3i-tdm6\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Raleigh McCoy\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"wg3i-tdm6\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Raleigh McCoy\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Employment First Annual OVR Outcomes Current Statewide Labor & Industry\",\n            \"id\" : \"uimv-hpcj\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"The following are a selection of annual outcomes of services provided by the Pennsylvania's Department of Labor & Industry's Office of Vocational Rehabilitation.  Outcomes include applicants and case outcomes including employment and wages.\\n\\nKey Footnotes:\\n1) Employed in Competitive Labor Market means employment at or above the minimum wage in settings where most employees do not have disabilities.\\n2) Estimated Taxes Paid are based on a standard deduction for the year, annual tax brackets and rates established by the IRS, and flat-rate FICA, state, and local taxes.\\n3) Estimated Total Government Savings are estimated federal, state, and local taxes paid plus annualized public support dollars at closure.\\n4) Average per Person Cost for a Competitive Employment Placement is the average individual \\\"life of case\\\" cost for all persons having a competitive employment outcome regardless of total number of years receiving services.\\n5) Average per Person Cost of Services is the average individual \\\"life of case\\\" cost for all persons having an employment outcome regardless of total number of years receiving services.\\n6)  Source: U.S. Department of Labor, Bureau of Labor Statistics, May 2016 State Occupational Employment and Wage Estimates, Pennsylvania, https://www.bls.gov/oes/current/oes_pa.htm#00-0000.\",\n            \"attribution\" : \"Department of Labor and Industry\",\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2023-02-08T19:15:06.000Z\",\n            \"createdAt\" : \"2021-06-03T16:03:29.000Z\",\n            \"metadata_updated_at\" : \"2023-02-08T19:15:06.000Z\",\n            \"data_updated_at\" : \"2023-02-08T19:14:57.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 7,\n                \"page_views_last_month\" : 16,\n                \"page_views_total\" : 870,\n                \"page_views_last_week_log\" : 3.0,\n                \"page_views_last_month_log\" : 4.08746284125034,\n                \"page_views_total_log\" : 9.766528908598865\n              },\n            \"columns_name\" :\n              [\n                \"Percentage of Applicants Found Eligible\",\n                \"New Applicants for Services\",\n                \"Average Hourly Wage of Individuals Employed\",\n                \"Projected Time (in Months) to Recover Investment\",\n                \"Period\",\n                \"Individuals Employed in the Competitive Labor Market (1)\",\n                \"Cases Open 00-39 at end of Year\",\n                \"Applicants Found Eligible\",\n                \"Average Time in Months from Acceptance to Successful Closure\",\n                \"Average per Person Cost of Services \",\n                \"Average per Person Cost for a Competitive Employment Placement (4)\",\n                \"Estimated Total Government Savings\",\n                \"Estimated Federal, State, and Local Taxes Paid By These New Workers\",\n                \"Percent of Individuals Employed in the Competitive Labor Market\",\n                \"Individuals Placed into Employment\",\n                \"Cases Closed During Year\",\n                \"Individuals engaged with OVR during the Program Year\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"percentage_of_applicants\",\n                \"new_applicants_for_services\",\n                \"average_hourly_wage_of\",\n                \"projected_time_in_months\",\n                \"period\",\n                \"individuals_employed_in_the\",\n                \"cases_open_00_39_at_end_of\",\n                \"applicants_found_eligible\",\n                \"average_time_in_months_from\",\n                \"average_per_person_cost_of\",\n                \"average_per_person_cost_for\",\n                \"estimated_total_government\",\n                \"estimated_federal_state_and\",\n                \"percent_of_individuals\",\n                \"individuals_placed_into\",\n                \"cases_closed_during_year\",\n                \"individuals_engaged_with\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"Applicants Found Eligible divided by New Applicants\",\n                \"Old Status Code 02 between 7/1 -6/30; distinct PIDS (Case History Report PY2019)\",\n                \"PA average for all occupations (2019): $24.686  RSA standard: \\\"VR consumers served by general/combined agencies who achieved competitive outcomes are earning, on the average, at least 52 cents for every dollar earned hourly by all employed individuals in the state.\\\"  OVR Program Year 2019 ratio: 57 cents for every dollar earned hourly by all employed individuals in the state (calculated as $14.11/$24.68), exceeding the RSA standard by 5 cents, or 9.94.%.  OVR Program Year 2019 Average Hourly wages: From 'PY2019 26 Closures for Highlight' sheet - 1 Tab, column 'K' (Average of DE359 from Q4 PY2019 RSA911 for cases closed DE354 as \\\"6\\\" and DE353 within PY2019 was $14.30)\",\n                \"Time to recover investment in months.\",\n                \"Identifies the Federal Fiscal Year or State Program Year for the provided statistics.\",\n                \"Employment in Competitive Placement means employment at or above minimum wage in settings where most employees do not have disabilities. (1)\",\n                \"Ad hoc Case History Report *PY2019 include a period when the Order of Selection was Closed\",\n                \"Old Status Code 10 between 7/1 -6/30; distinct PIDS (Case History Report PY2019)\",\n                \"\",\n                \"Average individual “life of case” cost for all persons having a competitive employment outcome regardless of total number of years receiving services.\",\n                \"Average individual “life of case” cost for all persons having a competitive employment outcome regardless of total number of years receiving services.\",\n                \"Estimated federal, state, and local taxes paid plus annualized public support dollars at closure.\",\n                \"Based on a standard deduction for the year, annual tax brackets and rates established by the IRS, and flat-rate FICA, state, and local taxes.\",\n                \"Individuals placed in Competitive Employment divided by the total placements in all employment types.\",\n                \"Adhoc History Report (RSA-911 DE354, Type of Exit code 6=6932)\",\n                \"RSA-911 closures; RSA-911 DE354,  excludes -1 to -2 and 00 to 08 closures\",\n                \"FFY 2015-16: 51,267 (RPT019, Open 00-39, 10/1-9/30) + 21,208 (RSA-113 Year-end Report, Line D8) PY 2016-17: 49,636 (RPT019, Open 00-39 as of 6/30/2017) + 24,958 (All closures during the Program Year) PY 2017-18: 50,394 cases open 00-39 as of 6/30/2018 (ad hoc) + 21,940 closures during the Program Year (RSA-911; excludes -1--2 and 00-08 closures) PY 2018-19: 47,425 cases open 00-39 as of 6/30/2019 (ad hoc) + 21,996 closures during the Program Year (RSA-911, validated in ad hoc, excludes -1 to -2 and 00 to 08 closures). PY 2019-20: 36,014 cases open 00-39 as of 6/30/2020 (ad hoc) + 18,535 closures during the Program Year (RSA-911 DE354,  excludes -1 to -2 and 00 to 08 closures). *PY2019 include a period when the Order of Selection was Closed\"\n              ],\n            \"columns_format\" :\n              [\n                { \"precisionStyle\" : \"percentage\", \"percentScale\" : \"1\" },\n                {},\n                { \"precisionStyle\" : \"currency\", \"currencyStyle\" : \"USD\" },\n                { \"precision\" : \"1\" },\n                {},\n                {},\n                {},\n                {},\n                { \"precision\" : \"1\" },\n                {\n                  \"precisionStyle\" : \"currency\",\n                  \"currencyStyle\" : \"USD\",\n                  \"precision\" : \"0\"\n                },\n                {\n                  \"precisionStyle\" : \"currency\",\n                  \"currencyStyle\" : \"USD\",\n                  \"precision\" : \"0\"\n                },\n                {\n                  \"precisionStyle\" : \"currency\",\n                  \"currencyStyle\" : \"USD\",\n                  \"precision\" : \"0\"\n                },\n                {\n                  \"precisionStyle\" : \"currency\",\n                  \"currencyStyle\" : \"USD\",\n                  \"precision\" : \"0\"\n                },\n                { \"precisionStyle\" : \"percentage\", \"percentScale\" : \"1\" },\n                {},\n                {},\n                {}\n              ],\n            \"download_count\" : 100,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2023-02-08T19:15:06.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"economy\", \"social services\", \"finance\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Employment First\",\n            \"domain_tags\" :\n              [\n                \"labor\",\n                \"disability\",\n                \"dli\",\n                \"employment\",\n                \"employment first\",\n                \"labor and industry\",\n                \"l&i\",\n                \"outcomes\",\n                \"ovr\",\n                \"vocational\"\n              ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Data-Management_Business-Owner\",\n                  \"value\" : \"Department of Labor and Industry (DLI)\"\n                },\n                {\n                  \"key\" : \"Data-Management_Update-Frequency\",\n                  \"value\" : \"Annually\"\n                }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"data.pa.gov\",\n            \"license\" : \"Public Domain U.S. Government\"\n          },\n        \"permalink\" : \"https://data.pa.gov/d/uimv-hpcj\",\n        \"link\" : \"https://data.pa.gov/Employment-First/Employment-First-Annual-OVR-Outcomes-Current-State/uimv-hpcj\",\n        \"owner\" :\n          {\n            \"id\" : \"s9q8-jynp\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"John Long\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"s9q8-jynp\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"John Long\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Citizen Satisfaction Survey (2018-2021)\",\n            \"id\" : \"btc8-9kef\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"These are the results of the 2018 to 2021 Citizen Satisfaction survey. To see the most recent reports, visit <a href=\\\"https://calgary.ca/citizensatisfaction\\\">Calgary.ca/citizensatisfaction</a>.\\n\\nFor detailed information on the variables in this dataset, <a href=\\\"https://data.calgary.ca/api/views/btc8-9kef/files/8edca0d5-637f-4333-aaf1-f00a61a1fc11?download=true&filename=Variable-metadata%202018-2021.xlsx\\\">see the variable metadata</a>.\\n\\nMethodology\\nThe Citizen Satisfaction survey is a telephone survey conducted with a randomly selected sample of Calgarians aged 18 years and older. The survey is conducted on an annual basis.\\nThe data are weighted to ensure the overall sample’s quadrant, ward, and age/gender composition reflects that of the actual Calgary population aged 18 or older according to Municipal and Federal Census data. Weights are included in the dataset.\\n\\n<a href=\\\"https://data.calgary.ca/api/views/btc8-9kef/files/8edca0d5-637f-4333-aaf1-f00a61a1fc11?download=true&filename=Variable-metadata%202018-2021.xlsx\\\">The variable metadata</a> contains detailed information on the variables.\",\n            \"attribution\" : \"The City of Calgary\",\n            \"attribution_link\" : \"https://calgary.ca/citizensatisfaction\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2023-02-01T15:39:18.000Z\",\n            \"createdAt\" : \"2021-06-10T19:07:06.000Z\",\n            \"metadata_updated_at\" : \"2023-02-01T15:39:18.000Z\",\n            \"data_updated_at\" : \"2022-05-31T20:31:33.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 14,\n                \"page_views_last_month\" : 34,\n                \"page_views_total\" : 2443,\n                \"page_views_last_week_log\" : 3.9068905956085187,\n                \"page_views_last_month_log\" : 5.129283016944966,\n                \"page_views_total_log\" : 11.255028569818728\n              },\n            \"columns_name\" :\n              [\n                \"q9_2_11\",\n                \"q8_24\",\n                \"q9_1_19\",\n                \"q9_1_20\",\n                \"q34\",\n                \"q3\",\n                \"q24bx_3\",\n                \"q24bx_5\",\n                \"q24bx_6\",\n                \"q19_5\",\n                \"q11a\",\n                \"q8_8\",\n                \"q8_15\",\n                \"q8_9\",\n                \"q8_13\",\n                \"q8_16\",\n                \"q8_2\",\n                \"q12\",\n                \"q19_8\",\n                \"q19_3\",\n                \"q2a\",\n                \"q37\",\n                \"market2\",\n                \"Mweight0\",\n                \"q9_2_33\",\n                \"q9_2_24\",\n                \"q9_2_14\",\n                \"q9_2_13\",\n                \"q9_2_4\",\n                \"q9_2_1\",\n                \"q9_1_34\",\n                \"q9_1_27\",\n                \"q9_1_23\",\n                \"q9_1_18\",\n                \"q9_1_17\",\n                \"q9_1_15\",\n                \"q9_1_13\",\n                \"q9_1_12\",\n                \"q9_1_5\",\n                \"q9_1_4\",\n                \"q9_1_3\",\n                \"q8_30\",\n                \"q8_28\",\n                \"q9_2_2\",\n                \"q9_2_26\",\n                \"q9_2_28\",\n                \"q8_19\",\n                \"q9_2_7\",\n                \"s4qt\",\n                \"q32x\",\n                \"q38\",\n                \"q9_2_22\",\n                \"q9_1_35\",\n                \"q9_1_32\",\n                \"q9_1_2\",\n                \"q19_1\",\n                \"q19_7\",\n                \"q8_1\",\n                \"q8_20\",\n                \"q8_27\",\n                \"q8_32\",\n                \"q8_5\",\n                \"q9_1_10\",\n                \"q9_1_11\",\n                \"q9_1_14\",\n                \"q9_1_31\",\n                \"q9_1_8\",\n                \"q9_2_18\",\n                \"q9_1_24\",\n                \"q8_31\",\n                \"q8_7\",\n                \"q8_6\",\n                \"q24cx\",\n                \"q10\",\n                \"q19_2\",\n                \"q19_4\",\n                \"q8_4\",\n                \"q8_10\",\n                \"q8_12\",\n                \"q8_14\",\n                \"q8_25\",\n                \"q8_23\",\n                \"q8_21\",\n                \"q8_18\",\n                \"q8_3\",\n                \"q9_2_32\",\n                \"q9_2_25\",\n                \"q9_2_21\",\n                \"q9_2_20\",\n                \"qwave\",\n                \"q39\",\n                \"q30\",\n                \"sexfix\",\n                \"q24bx_1\",\n                \"q9_2_17\",\n                \"q24bx_2\",\n                \"q24bx_4\",\n                \"q24bx_7\",\n                \"q9_2_9\",\n                \"q9_2_6\",\n                \"q9_2_5\",\n                \"q9_1_26\",\n                \"q9_1_6\",\n                \"q8_35\",\n                \"q8_34\",\n                \"q8_17\",\n                \"q8_11\",\n                \"q40\",\n                \"q9_2_23\",\n                \"q9_2_19\",\n                \"q9_2_12\",\n                \"q9_2_8\",\n                \"q9_2_3\",\n                \"q9_1_30\",\n                \"q9_1_28\",\n                \"q9_1_21\",\n                \"q9_1_16\",\n                \"q8_33\",\n                \"q8_29\",\n                \"q8_22\",\n                \"q19_6\",\n                \"q9_1_33\",\n                \"q9_1_1\",\n                \"q9_1_7\",\n                \"q9_1_9\",\n                \"q9_1_22\",\n                \"q9_2_27\",\n                \"q9_1_25\",\n                \"q9_2_16\",\n                \"q29x\",\n                \"q9_1_29\",\n                \"q9_2_10\",\n                \"q9_2_15\",\n                \"q9_2_31\",\n                \"q8_26\",\n                \"q9_2_35\",\n                \"q9_2_34\",\n                \"q9_2_30\",\n                \"q9_2_29\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"q9_2_11\",\n                \"q8_24\",\n                \"q9_1_19\",\n                \"q9_1_20\",\n                \"q34\",\n                \"q3\",\n                \"q24bx_3\",\n                \"q24bx_5\",\n                \"q24bx_6\",\n                \"q19_5\",\n                \"q11a\",\n                \"q8_8\",\n                \"q8_15\",\n                \"q8_9\",\n                \"q8_13\",\n                \"q8_16\",\n                \"q8_2\",\n                \"q12\",\n                \"q19_8\",\n                \"q19_3\",\n                \"q2a\",\n                \"q37\",\n                \"market2\",\n                \"mweight0\",\n                \"q9_2_33\",\n                \"q9_2_24\",\n                \"q9_2_14\",\n                \"q9_2_13\",\n                \"q9_2_4\",\n                \"q9_2_1\",\n                \"q9_1_34\",\n                \"q9_1_27\",\n                \"q9_1_23\",\n                \"q9_1_18\",\n                \"q9_1_17\",\n                \"q9_1_15\",\n                \"q9_1_13\",\n                \"q9_1_12\",\n                \"q9_1_5\",\n                \"q9_1_4\",\n                \"q9_1_3\",\n                \"q8_30\",\n                \"q8_28\",\n                \"q9_2_2\",\n                \"q9_2_26\",\n                \"q9_2_28\",\n                \"q8_19\",\n                \"q9_2_7\",\n                \"s4qt\",\n                \"q32x\",\n                \"q38\",\n                \"q9_2_22\",\n                \"q9_1_35\",\n                \"q9_1_32\",\n                \"q9_1_2\",\n                \"q19_1\",\n                \"q19_7\",\n                \"q8_1\",\n                \"q8_20\",\n                \"q8_27\",\n                \"q8_32\",\n                \"q8_5\",\n                \"q9_1_10\",\n                \"q9_1_11\",\n                \"q9_1_14\",\n                \"q9_1_31\",\n                \"q9_1_8\",\n                \"q9_2_18\",\n                \"q9_1_24\",\n                \"q8_31\",\n                \"q8_7\",\n                \"q8_6\",\n                \"q24cx\",\n                \"q10\",\n                \"q19_2\",\n                \"q19_4\",\n                \"q8_4\",\n                \"q8_10\",\n                \"q8_12\",\n                \"q8_14\",\n                \"q8_25\",\n                \"q8_23\",\n                \"q8_21\",\n                \"q8_18\",\n                \"q8_3\",\n                \"q9_2_32\",\n                \"q9_2_25\",\n                \"q9_2_21\",\n                \"q9_2_20\",\n                \"qwave\",\n                \"q39\",\n                \"q30\",\n                \"sexfix\",\n                \"q24bx_1\",\n                \"q9_2_17\",\n                \"q24bx_2\",\n                \"q24bx_4\",\n                \"q24bx_7\",\n                \"q9_2_9\",\n                \"q9_2_6\",\n                \"q9_2_5\",\n                \"q9_1_26\",\n                \"q9_1_6\",\n                \"q8_35\",\n                \"q8_34\",\n                \"q8_17\",\n                \"q8_11\",\n                \"q40\",\n                \"q9_2_23\",\n                \"q9_2_19\",\n                \"q9_2_12\",\n                \"q9_2_8\",\n                \"q9_2_3\",\n                \"q9_1_30\",\n                \"q9_1_28\",\n                \"q9_1_21\",\n                \"q9_1_16\",\n                \"q8_33\",\n                \"q8_29\",\n                \"q8_22\",\n                \"q19_6\",\n                \"q9_1_33\",\n                \"q9_1_1\",\n                \"q9_1_7\",\n                \"q9_1_9\",\n                \"q9_1_22\",\n                \"q9_2_27\",\n                \"q9_1_25\",\n                \"q9_2_16\",\n                \"q29x\",\n                \"q9_1_29\",\n                \"q9_2_10\",\n                \"q9_2_15\",\n                \"q9_2_31\",\n                \"q8_26\",\n                \"q9_2_35\",\n                \"q9_2_34\",\n                \"q9_2_30\",\n                \"q9_2_29\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"Service Investment_ Calgary Transit including bus and CTrain service.\",\n                \"Service Importance_ City operated recreation FACILITIES such as pools, leisure centres, and golf courses.\",\n                \"Service Satisfaction_ Calgary's parks, playgrounds and other open spaces.\",\n                \"Service Satisfaction_ Community services such as support for community associations and not for profit groups.\",\n                \"Household tenancy.\",\n                \"Change in quality of life. (Likert scale)\",\n                \"I am proud to be a Calgarian. (Likert scale)\",\n                \"I am regularly involved in neighbourhood and local community events. (Likert scale)\",\n                \"Calgary is a great place to make a living. (Likert scale)\",\n                \"The City of Calgary practices open and accessible government. \",\n                \"Please rate the value you feel you receive from your municipal property tax dollars.\",\n                \"Service Importance_  Residential Green Cart service.\",\n                \"Service Importance_ Snow removal. \",\n                \"Service Importance_  The quality of drinking water.\",\n                \"Service Importance_ Road maintenance including pothole repairs.\",\n                \"Service Importance_ Traffic flow management. \",\n                \"Service Importance_  Calgary Fire Department.\",\n                \"Increase taxes vs cut services.\",\n                \"The City used input from Calgarians in decision-making about City projects and services.\",\n                \"City staff are courteous, helpful, and knowledgeable. \",\n                \"Overall quality of life. (Likert scale)\",\n                \"Years in Calgary.\",\n                \"City of Calgary Ward.\",\n                \"Survey weight.\",\n                \"Service Investment_ Property tax assessment.\",\n                \"Service Investment_ City operated recreation FACILITIES such as pools, leisure centres, and golf courses.\",\n                \"Service Investment_ Spring road cleaning.\",\n                \"Service Investment_ Road maintenance including pothole repairs.\",\n                \"Service Investment_  Protection from river flooding.\",\n                \"Service Investment_  Calgary Police Service.\",\n                \"Service Satisfaction_ City of Calgary website.\",\n                \"Service Satisfaction_ Calgary's pathway system.\",\n                \"Service Satisfaction_ City operated recreation PROGRAMS such as swimming lessons.\",\n                \"Service Satisfaction_ Animal control services for stray animals and pet licensing.\",\n                \"Service Satisfaction_ Bylaw services for things such as noise complaints, fire pits and weeds.\",\n                \"Service Satisfaction_ Snow removal.\",\n                \"Service Satisfaction_ Road maintenance including pothole repairs.\",\n                \"Service Satisfaction_ City operated roads and infrastructure.\",\n                \"Service Satisfaction_  Disaster planning and response.\",\n                \"Service Satisfaction_  Protection from river flooding.\",\n                \"Service Satisfaction_ 911.\",\n                \"Service Importance_ Business licenses and inspections.\",\n                \"Service Importance_ City land use planning.\",\n                \"Service Investment_  Calgary Fire Department.\",\n                \"Service Investment_ On-street bikeways.\",\n                \"Service Investment_ City land use planning.\",\n                \"Service Importance_ Calgary's parks, playgrounds and other open spaces.\",\n                \"Service Investment_  Residential Blue Cart recycling.\",\n                \"Quadrant of Calgary.\",\n                \"Children in household.\",\n                \"Highest level of education.\",\n                \"Service Investment_ Affordable housing for low.\",\n                \"Service Satisfaction_ 311 service.\",\n                \"Service Satisfaction_ Downtown revitalization.\",\n                \"Service Satisfaction_  Calgary Fire Department.\",\n                \"The quality of customer service from the city is consistently high.\",\n                \"The City allows citizen to have meaningful input into decision-making.\",\n                \"Service Importance_  Calgary Police Service. \",\n                \"Service Importance_ Community services such as support for community associations and not for profit groups.\",\n                \"Service Importance_ Calgary's pathway system.\",\n                \"Service Importance_ Downtown revitalization.\",\n                \"Service Importance_  Disaster planning and response.\",\n                \"Service Satisfaction_ Transportation planning.\",\n                \"Service Satisfaction_ Calgary Transit including bus and CTrain service.\",\n                \"Service Satisfaction_ Spring road cleaning.\",\n                \"Service Satisfaction_ City growth management.\",\n                \"Service Satisfaction_  Residential Green Cart service.\",\n                \"Service Investment_ Animal control services for stray animals and pet licensing.\",\n                \"Service Satisfaction_ City operated recreation FACILITIES such as pools, leisure centres, and golf courses.\",\n                \"Service Importance_ City growth management.\",\n                \"Service Importance_  Residential Blue Cart recycling .\",\n                \"Service Importance_  Residential garbage collection service.\",\n                \"Calgary is on the right track to being a better city 10 years from now. \",\n                \"How safe do you or would you feel walking alone in your neighborhood after dark.\",\n                \"The city responds quickly to requests and concerns.\",\n                \"City staff are easy to get a hold of when I need them. \",\n                \"Service Importance_  Protection from river flooding.\",\n                \"Service Importance_ Transportation planning. \",\n                \"Service Importance_ City operated roads and infrastructure.\",\n                \"Service Importance_ Spring road cleaning. \",\n                \"Service Importance_ Support for arts and culture including festivals.\",\n                \"Service Importance_ City operated recreation PROGRAMS such as swimming lessons.\",\n                \"Service Importance_ Social services for individuals such as seniors or youth.\",\n                \"Service Importance_ Animal control services for stray animals and pet licensing.\",\n                \"Service Importance_ 911.\",\n                \"Service Investment_ Downtown revitalization.\",\n                \"Service Investment_ Support for arts and culture including festivals.\",\n                \"Service Investment_ Social services for individuals such as seniors or youth.\",\n                \"Service Investment_ Community services such as support for community associations and not for profit groups.\",\n                \"Year of survey.\",\n                \"Household income category.\",\n                \"Age group.\",\n                \"Gender (assumed).\",\n                \"Calgary is moving in the right direction to ensure a high quality of life for future generations. (Likert scale)\",\n                \"Service Investment_ Bylaw services for things such as noise complaints, fire pits and weeds.\",\n                \"The City of Calgary, municipal government, fosters a city that is inclusive and accepting of all. (Likert scale)\",\n                \"I am proud to live in my neighbourhood. (Likert scale)\",\n                \"Calgary is a great place to make a life. (Likert scale)\",\n                \"Service Investment_  The quality of drinking water.\",\n                \"Service Investment_  Residential garbage collection service.\",\n                \"Service Investment_  Disaster planning and response.\",\n                \"Service Satisfaction_ On-street bikeways.\",\n                \"Service Satisfaction_  Residential garbage collection service.\",\n                \"Service Importance_ 311 service.\",\n                \"Service Importance_ City of Calgary website.\",\n                \"Service Importance_ Bylaw services for things such as noise complaints, fire pits and weeds.\",\n                \"Service Importance_ Calgary Transit including bus and CTrain service.\",\n                \"A member of visible minority.\",\n                \"Service Investment_ City operated recreation PROGRAMS such as swimming lessons.\",\n                \"Service Investment_ Calgary's parks, playgrounds and other open spaces.\",\n                \"Service Investment_ City operated roads and infrastructure.\",\n                \"Service Investment_  Residential Green Cart service.\",\n                \"Service Investment_ 911.\",\n                \"Service Satisfaction_ Business licenses and inspections.\",\n                \"Service Satisfaction_ City land use planning.\",\n                \"Service Satisfaction_ Social services for individuals such as seniors or youth.\",\n                \"Service Satisfaction_ Traffic flow management.\",\n                \"Service Importance_ Property tax assessment.\",\n                \"Service Importance_ Development and building inspections and permits.\",\n                \"Service Importance_ Affordable housing for low.\",\n                \"The City of Calgary makes customer service a priority.\",\n                \"Service Satisfaction_ Property tax assessment.\",\n                \"Service Satisfaction_  Calgary Police Service.\",\n                \"Service Satisfaction_  Residential Blue Cart recycling.\",\n                \"Service Satisfaction_  The quality of drinking water.\",\n                \"Service Satisfaction_ Affordable housing for low.\",\n                \"Service Investment_ Calgary's pathway system.\",\n                \"Service Satisfaction_ Support for arts and culture including festivals.\",\n                \"Service Investment_ Traffic flow management.\",\n                \"Gender.\",\n                \"Service Satisfaction_ Development and building inspections and permits.\",\n                \"Service Investment_ Transportation planning.\",\n                \"Service Investment_ Snow removal.\",\n                \"Service Investment_ City growth management.\",\n                \"Service Importance_ On-street bikeways.\",\n                \"Service Investment_ 311 service.\",\n                \"Service Investment_ City of Calgary website.\",\n                \"Service Investment_ Business licenses and inspections.\",\n                \"Service Investment_ Development and building inspections and permits.\"\n              ],\n            \"columns_format\" :\n              [\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {}\n              ],\n            \"download_count\" : 353,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2021-06-10T19:31:20.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [\n                             \"environment\",\n                             \"infrastructure\",\n                             \"transportation\"\n                           ],\n            \"tags\" : [],\n            \"domain_category\" : \"Help and Information\",\n            \"domain_tags\" :\n              [\n                \"research\",\n                \"perception\",\n                \"public\",\n                \"satisfaction\",\n                \"survey\",\n                \"citizen\",\n                \"citsat\",\n                \"opinion\"\n              ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Data-Supplier_Organization\",\n                  \"value\" : \"The City of Calgary\"\n                },\n                {\n                  \"key\" : \"Data-Supplier_Business-Unit\",\n                  \"value\" : \"Customer Serv - Comm\"\n                },\n                {\n                  \"key\" : \"Geospatial-Information_Dataset-contains-geospatial-information\",\n                  \"value\" : \"No\"\n                },\n                { \"key\" : \"Time/Date_Update-Frequency\", \"value\" : \"None\" },\n                {\n                  \"key\" : \"License/Attribution_License-URL\",\n                  \"value\" : \"https://data.calgary.ca/d/Open-Data-Terms/u45n-7awa\"\n                }\n              ]\n          },\n        \"metadata\" :\n          { \"domain\" : \"data.calgary.ca\", \"license\" : \"See Terms of Use\" },\n        \"permalink\" : \"https://data.calgary.ca/d/btc8-9kef\",\n        \"link\" : \"https://data.calgary.ca/Help-and-Information/Citizen-Satisfaction-Survey-2018-2021-/btc8-9kef\",\n        \"owner\" :\n          {\n            \"id\" : \"55bi-hyk4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Calgary Open Data\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"55bi-hyk4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Calgary Open Data\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"ED Total Private Covered Employment\",\n            \"id\" : \"ic6v-dypw\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Total private-sector employment for jobs covered by Unemployment Insurance as reported by employers through the Quarterly Census of Employment and Wages (QCEW).\",\n            \"attribution\" : \"Bureau of Labor Statistics\",\n            \"attribution_link\" : \"https://www.bls.gov/cew/\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2024-04-17T18:09:50.000Z\",\n            \"createdAt\" : \"2019-07-31T18:02:10.000Z\",\n            \"metadata_updated_at\" : \"2024-04-17T18:09:49.000Z\",\n            \"data_updated_at\" : \"2024-04-17T18:09:50.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 0,\n                \"page_views_last_month\" : 0,\n                \"page_views_total\" : 390,\n                \"page_views_last_week_log\" : 0.0,\n                \"page_views_last_month_log\" : 0.0,\n                \"page_views_total_log\" : 8.611024797307353\n              },\n            \"columns_name\" :\n              [\n                \"Month\",\n                \"Date\",\n                \"Goods\",\n                \"Services\",\n                \"% Goods-producing\",\n                \"% Services-producing\",\n                \"YoY Change Total\",\n                \"YoY Change Services\",\n                \"YoY Change Goods\",\n                \"Total\",\n                \"Year\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"month\",\n                \"date\",\n                \"goods\",\n                \"services\",\n                \"percentg\",\n                \"percentg_1\",\n                \"yoychanget\",\n                \"yoychangep\",\n                \"yoychangeg\",\n                \"total\",\n                \"year\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Calendar date\",\n                \"Calendar date\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"Month of employment count\",\n                \"Month of employment count\",\n                \"Total covered employment in \\\"goods producing\\\" industries of Resources, Construction & Manufacturing\",\n                \"Total covered employment in \\\"services producing\\\" industries which includes most industries not included in \\\"goods producing\\\"\",\n                \"Employment in \\\"goods producing\\\" industries as a percent of total covered employment\",\n                \"Employment in \\\"services producing\\\" industries as a percent of total covered employment\",\n                \"Year-over-year change in total employment\",\n                \"Year-over-year change in \\\"services producing\\\" employment\",\n                \"Year-over-year change in \\\"goods producing\\\" employment\",\n                \"Total covered employment\",\n                \"Year of employment count\"\n              ],\n            \"columns_format\" :\n              [\n                {},\n                {},\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"percentage\",\n                  \"percentScale\" : \"1\",\n                  \"precision\" : \"1\"\n                },\n                {\n                  \"precisionStyle\" : \"percentage\",\n                  \"percentScale\" : \"1\",\n                  \"precision\" : \"1\"\n                },\n                {},\n                {},\n                {},\n                {},\n                { \"noCommas\" : \"true\" }\n              ],\n            \"download_count\" : 60,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2019-07-31T18:17:33.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"economy\", \"infrastructure\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Business\",\n            \"domain_tags\" : [],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Publishing_Department\",\n                  \"value\" : \"Economic Development\"\n                },\n                { \"key\" : \"Publishing_Dataset-Start-Year\", \"value\" : \"2008\" },\n                {\n                  \"key\" : \"Publishing_Strategic-Objective\",\n                  \"value\" : \"Jobs and Entrepreneurship\"\n                },\n                {\n                  \"key\" : \"Publishing_Priority-Areas\",\n                  \"value\" : \"Entrepreneurial Climate\"\n                },\n                {\n                  \"key\" : \"Publishing_Terms-of-Use\",\n                  \"value\" : \"https://internal.open.piercecountywa.gov/stories/s/t3r8-e9ff\"\n                },\n                {\n                  \"key\" : \"Publishing_Update-Frequency\",\n                  \"value\" : \"Quarterly\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"internal.open.piercecountywa.gov\" },\n        \"permalink\" : \"https://internal.open.piercecountywa.gov/d/ic6v-dypw\",\n        \"link\" : \"https://internal.open.piercecountywa.gov/Business/ED-Total-Private-Covered-Employment/ic6v-dypw\",\n        \"owner\" :\n          {\n            \"id\" : \"5pem-6v9w\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Rob Allen\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"5pem-6v9w\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Rob Allen\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Quarterly Census of Employment and Wages Quarterly Data: Beginning 2000\",\n            \"id\" : \"cwsm-2ns3\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"The Quarterly Census of Employment and Wages (QCEW) program (also known as ES-202) collects employment and wage data from employers covered by New York State's Unemployment Insurance (UI) Law. This program is a cooperative program with the U.S. Bureau of Labor Statistics. QCEW data encompass approximately 97 percent of New York's nonfarm employment, providing a virtual census of employees and their wages as well as the most complete universe of employment and wage data, by industry, at the State, regional and county levels. \\\"Covered\\\" employment refers broadly to both private-sector employees as well as state, county, and municipal government employees insured under the New York State Unemployment Insurance (UI) Act. Federal employees are insured under separate laws, but are considered covered for the purposes of the program. Employee categories not covered by UI include some agricultural workers, railroad workers, private household workers, student workers, the self-employed, and unpaid family workers. QCEW data are similar to monthly Current Employment Statistics (CES) data in that they reflect jobs by place of work; therefore, if a person holds two jobs, he or she is counted twice. However, since the QCEW program, by definition, only measures employment covered by unemployment insurance laws, its totals will not be the same as CES employment totals due to the employee categories excluded by UI.\",\n            \"attribution\" : \"New York State Department of Labor\",\n            \"attribution_link\" : \"http://www.labor.state.ny.us/stats/LSQCEW.shtm\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-06-06T19:11:13.000Z\",\n            \"createdAt\" : \"2013-02-15T16:30:00.000Z\",\n            \"metadata_updated_at\" : \"2025-06-06T18:32:06.000Z\",\n            \"data_updated_at\" : \"2025-06-06T19:11:13.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 26,\n                \"page_views_last_month\" : 83,\n                \"page_views_total\" : 5806,\n                \"page_views_last_week_log\" : 4.754887502163469,\n                \"page_views_last_month_log\" : 6.39231742277876,\n                \"page_views_total_log\" : 12.503577318702689\n              },\n            \"columns_name\" :\n              [\n                \"Quarter\",\n                \"Area Type\",\n                \"Ownership\",\n                \"Establishments\",\n                \"Month 2 Employment\",\n                \"Month 3 Employment\",\n                \"Total Wage                                                                                                                       \",\n                \"NAICS Title\",\n                \"NAICS\",\n                \"Area\",\n                \"Month 1 Employment\",\n                \"Year\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"quarter\",\n                \"area_type\",\n                \"ownership\",\n                \"establishments\",\n                \"month_2_employment\",\n                \"month_3_employment\",\n                \"total_wage\",\n                \"naics_title\",\n                \"naics\",\n                \"area\",\n                \"month_1_employment\",\n                \"year\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"Quarter of the Year (Q1.. Jan-Mar,Q2..Apr-Jun)\",\n                \"Geographic Boundary Type\",\n                \"Private, Federal, State, or Local Government\",\n                \"All employers subject to UI laws.\",\n                \"Monthly employment figures representing the number of people either working during or receiving pay for the payroll period.\",\n                \"Monthly employment figures representing the number of people either working during or receiving pay for the payroll period.\",\n                \"Total wages cover all wages and salaries paid to individuals in insured employment.\",\n                \"For data definitions go to the About tab and review the Overview Document\",\n                \"Industrial classification data are classified in accordance with the 2002 North American Industry Classification System (NAICS), which recently replaced the long-standing Standard Industrial Classification (SIC) system.\",\n                \"Geographic Area Name\",\n                \"Monthly employment figures representing the number of people either working during or receiving pay for the payroll period.\",\n                \"Year\"\n              ],\n            \"columns_format\" :\n              [\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\",\n                  \"currencyStyle\" : \"USD\",\n                  \"humane\" : \"false\",\n                  \"precisionStyle\" : \"currency\"\n                },\n                { \"align\" : \"left\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"center\"\n                }\n              ],\n            \"download_count\" : 2936,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2023-07-25T17:18:22.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"economy\", \"finance\", \"transportation\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Economic Development\",\n            \"domain_tags\" :\n              [ \"employment\", \"industry\", \"labor statistics\", \"payroll\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Additional-Resources_See-Also\",\n                  \"value\" : \"http://www.bls.gov/cew/\"\n                },\n                {\n                  \"key\" : \"Additional-Resources_See-Also-\",\n                  \"value\" : \"http://www.bls.gov/cew/cewfaq.htm\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Dataset-Owner\",\n                  \"value\" : \"Bureau of Statistics, Quarterly Census of Employment and Wages Unit\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Units\",\n                  \"value\" : \"Number of Establishments, Monthly Employment, Total Payroll, Average Employment, Average Payroll \"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Contact-Information\",\n                  \"value\" : \"rsask@labor.ny.gov\"\n                },\n                { \"key\" : \"Dataset-Summary_Granularity\", \"value\" : \"County\" },\n                {\n                  \"key\" : \"Dataset-Summary_Coverage\",\n                  \"value\" : \"Statewide, Region, Workforce Investment Area, Metropolitan Statistical Area, and County\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Data-Frequency\",\n                  \"value\" : \"Quarterly\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Posting-Frequency\",\n                  \"value\" : \"Quarterly\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Organization\",\n                  \"value\" : \"Division of Research and Statistics\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Time-Period\",\n                  \"value\" : \"2000 quarter 1-Present\"\n                },\n                {\n                  \"key\" : \"Dataset-Information_Agency\",\n                  \"value\" : \"Labor, Department of\"\n                },\n                {\n                  \"key\" : \"Notes_Notes\",\n                  \"value\" : \"The Bureau of Labor Statistics has set standards for States regarding maintaining confidentiality. As such certain industries and/or geographic areas have been suppressed \"\n                },\n                {\n                  \"key\" : \"Disclaimers_Limitations\",\n                  \"value\" : \"Certain data are suppressed to maintain confidentiality of employers. This dataset is only computed once all four quarters are released. Government ownership firms are allocated to either Federal, State, or Local. Employee categories not covered by UI include some agricultural workers, railroad workers, private household workers, student workers, the self-employed, and unpaid family workers. \"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.ny.gov\" },\n        \"permalink\" : \"https://data.ny.gov/d/cwsm-2ns3\",\n        \"link\" : \"https://data.ny.gov/Economic-Development/Quarterly-Census-of-Employment-and-Wages-Quarterly/cwsm-2ns3\",\n        \"owner\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Public Assistance Case Denials by Reason for Denial: Beginning 2006\",\n            \"id\" : \"tyyj-jgv5\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset, from New York State Office of Temporary and Disability Assistance, provides the number of Public Assistance case denials in each month by reason for case denial, for each Local Social Services District (SSD).  It is similar to data published on an annual basis in the \\\"Statistical Report on the Operations of New York State Public Assistance Programs.\\\"\",\n            \"attribution\" : \"New York State Office of Temporary and Disability Assistance (OTDA)\",\n            \"attribution_link\" : \"https://otda.ny.gov/resources/legislative-report/\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-09T13:01:41.000Z\",\n            \"createdAt\" : \"2016-05-10T16:50:36.000Z\",\n            \"metadata_updated_at\" : \"2025-07-09T13:01:40.000Z\",\n            \"data_updated_at\" : \"2025-07-09T13:01:41.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 8,\n                \"page_views_last_month\" : 58,\n                \"page_views_total\" : 4367,\n                \"page_views_last_week_log\" : 3.1699250014423126,\n                \"page_views_last_month_log\" : 5.882643049361842,\n                \"page_views_total_log\" : 12.092757140919852\n              },\n            \"columns_name\" :\n              [\n                \"SNA Case Denials - Residence Issues\",\n                \"SNA Case Denials - Other\",\n                \"Month\",\n                \"Total Public Assistance (PA) Case Denials - Client Request\",\n                \"Month Code\",\n                \"Total PA Case Denials - Financial Issues\",\n                \"Total PA Case Denials - Compliance Issues / Employment\",\n                \"Total PA Case Denials - Compliance Issues / Other\",\n                \"FA Denials Case - Financial Issues\",\n                \"FA Case Denials - Residence Issues\",\n                \"FA Case Denials - Compliance Issues / Other\",\n                \"SNA Case Denials - Financial Issues\",\n                \"SNA Case Denials - Compliance Issues / Employment\",\n                \"Total PA Case Denials - Residence Issues\",\n                \"Total PA Case Denials - Other\",\n                \"Family Assistance (FA) Case Denials - Client Request\",\n                \"FA Case Denials - Compliance Issues / Employment\",\n                \"FA Case Denials - Other\",\n                \"Safety Net Assistance (SNA) Case Denials - Client Request\",\n                \"SNA Case Denials - Compliance Issues / Other\",\n                \"District Code\",\n                \"District\",\n                \"Year\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"sna_residence\",\n                \"sna_other\",\n                \"month\",\n                \"ta_client_req\",\n                \"month_code\",\n                \"ta_finance\",\n                \"ta_comp_employ\",\n                \"ta_comp_other\",\n                \"fa_finance\",\n                \"fa_residence\",\n                \"fa_comp_other\",\n                \"sna_finance\",\n                \"sna_comp_employ\",\n                \"ta_residence\",\n                \"ta_other\",\n                \"fa_client_req\",\n                \"fa_comp_employ\",\n                \"fa_other\",\n                \"sna_client_req\",\n                \"sna_comp_other\",\n                \"district_code\",\n                \"district\",\n                \"year\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"Safety Net Assistance case denials due to residence issues; these include cases not residing in the jurisdiction of application or where the client cannot be located.\",\n                \"Safety Net Assistance case denials due to issues not included in the previous categories.\",\n                \"Month data pertains to. Denials are reported on a monthly basis. Day is always the first day of the reference month. The first available month is January 2006.\",\n                \"Total Public Assistance case denials at the request of the client. Sum of Family Assistance and Safety Net Assistance case denials.\",\n                \"Number corresponding to month. January = 1, December = 12, etc.\",\n                \"Total Public Assistance case denials due to financial issues; these include increased earned or unearned income, exceeding resource limits, or other household circumstance changes that make the case financially ineligible. Sum of Family Assistance and Safety Net Assistance case denials.\",\n                \"Total Public Assistance case denials due to compliance issues related to employment; these include failure to participate as required in Public Assistance  work participation requirements, such as failure to cooperate with establishing employability, failure to attend work program assignments and voluntarily leaving or failing to accept employment without good cause. Sum of Family Assistance and Safety Net Assistance case denials.\",\n                \"Total Public Assistance case denials due to compliance issues other than employment; these include failure to comply with rules other than those related to employment, such as failure to show for eligibility interviews, provide required documentation to verify eligibility or comply with household composition requirements.  Sum of Family Assistance and Safety Net Assistance case denials.\",\n                \"Family Assistance case denials due to financial issues; these include increased earned or unearned income, exceeding resource limits, or other household circumstance changes that make the case financially ineligible.\",\n                \"Family Assistance case denials due to residence issues; these include cases not residing in the jurisdiction of application or where the client cannot be located.\",\n                \"Family Assistance case denials due to compliance issues other than employment; these include failure to comply with rules other than those related to employment, such as failure to show for eligibility interviews, provide required documentation to verify eligibility or comply with household composition requirements.\",\n                \"Safety Net Assistance case denials due to financial issues; these include increased earned or unearned income, exceeding resource limits, or other household circumstance changes that make the case financially ineligible.\",\n                \"Safety Net Assistance case denials due to compliance issues related to employment; these include failure to participate as required in Public Assistance  work participation requirements, such as failure to cooperate with establishing employability, failure to attend work program assignments and voluntarily leaving or failing to accept employment without good cause.\",\n                \"Total Public Assistance case denials due to residence issues; these include cases not residing in the jurisdiction of application or where the client cannot be located.  Sum of Family Assistance and Safety Net Assistance case denials.\",\n                \"Total Public Assistance case denials due to issues not included in the previous categories. Sum of Family Assistance and Safety Net Assistance case denials.\",\n                \"Family Assistance case denials at the request of the client.\",\n                \"Family Assistance case denials due to compliance issues related to employment; these include failure to participate as required in Public Assistance  work participation requirements, such as failure to cooperate with establishing employability, failure to attend work program assignments and voluntarily leaving or failing to accept employment without good cause.\",\n                \"Family Assistance case denials due to issues not included in the previous categories.\",\n                \"Safety Net Assistance case denials at the request of the client.\",\n                \"Safety Net Assistance case denials due to compliance issues other than employment; these include failure to comply with rules other than those related to employment, such as failure to show for eligibility interviews, provide required documentation to verify eligibility or comply with household composition requirements.\",\n                \"Contains a code ranging from 01 to 57 and 66,\\ndesignating each of the State’s Local Social\\nServices Districts, which are New York City and\\nthe remaining 57 counties. For the non-New\\nYork City counties, the code refers to the\\nalphabetical order of the district name (e.g.,\\nAlbany=01, Yates = 57). For New York City, the\\ncode is 66.\",\n                \"Text name of each social services district.\",\n                \"Year data pertains to\"\n              ],\n            \"columns_format\" :\n              [\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                { \"displayStyle\" : \"plain\", \"align\" : \"center\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                }\n              ],\n            \"download_count\" : 2588,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2025-01-09T19:43:50.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"finance\", \"social services\", \"economy\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Human Services\",\n            \"domain_tags\" :\n              [ \"case denials\", \"public assistance\", \"sna\", \"ta\", \"welfare\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Dataset-Summary_Dataset-Owner\",\n                  \"value\" : \"Office of Temporary and Disability Assistance (OTDA)\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Contact-Information\",\n                  \"value\" : \"britany.orlebeke@otda.ny.gov, samantha.wilbur@otda.ny.gov\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Granularity\",\n                  \"value\" : \"Local Social Services District \"\n                },\n                { \"key\" : \"Dataset-Summary_Coverage\", \"value\" : \"Statewide\" },\n                {\n                  \"key\" : \"Dataset-Summary_Posting-Frequency\",\n                  \"value\" : \"Quarterly\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Organization\",\n                  \"value\" : \"OTDA Bureau of Data Management and Analysis\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Time-Period\",\n                  \"value\" : \"Beginning 2006\"\n                },\n                { \"key\" : \"Local-Data_County-Filter\", \"value\" : \"Yes\" },\n                { \"key\" : \"Local-Data_County_Column\", \"value\" : \"district\" },\n                {\n                  \"key\" : \"Dataset-Information_Agency\",\n                  \"value\" : \"Temporary and Disability Assistance, Office of\"\n                },\n                {\n                  \"key\" : \"Notes_Notes\",\n                  \"value\" : \"Data is available 30 days following the end of the last reported month in the quarter.\"\n                },\n                {\n                  \"key\" : \"Disclaimers_Disclaimer\",\n                  \"value\" : \"Because the groupings of denial reasons coded into the classifications in this dataset have changed over time, and the data published represents the current grouping system, data here may not exactly match data in other published sources.\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.ny.gov\" },\n        \"permalink\" : \"https://data.ny.gov/d/tyyj-jgv5\",\n        \"link\" : \"https://data.ny.gov/Human-Services/Public-Assistance-Case-Denials-by-Reason-for-Denia/tyyj-jgv5\",\n        \"owner\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Vital Signs: Time in Congestion - Corridor (Updated October 2018)\",\n            \"id\" : \"f57x-8ifw\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"VITAL SIGNS INDICATOR\\nTime Spent in Congestion (T7)\\n\\nFULL MEASURE NAME\\nTime Spent in Congestion\\n\\nLAST UPDATED\\nOctober 2018\\n\\nDATA SOURCE\\nMTC/Iteris Congestion Analysis\\nNo link available\\n\\nCA Department of Finance Forms E-8 and E-5\\nhttp://www.dof.ca.gov/Forecasting/Demographics/Estimates/E-8/\\nhttp://www.dof.ca.gov/Forecasting/Demographics/Estimates/E-5/\\n\\nCA Employment Division Department: Labor Market Information\\nhttp://www.labormarketinfo.edd.ca.gov/\\n\\nCONTACT INFORMATION\\nvitalsigns.info@bayareametro.gov\\n\\nMETHODOLOGY NOTES (across all datasets for this indicator)\\nTime spent in congestion measures the hours drivers are in congestion on freeway facilities based on traffic data. In recent years, data for the Bay Area comes from INRIX, a company that collects real-time traffic information from a variety of sources including mobile phone data and other GPS locator devices. The data provides traffic speed on the region’s highways. Using historical INRIX data (and similar internal datasets for some of the earlier years), MTC calculates an annual time series for vehicle hours spent in congestion in the Bay Area. Time spent in congestion is defined as the average daily hours spent in congestion on Tuesdays, Wednesdays and Thursdays during peak traffic months on freeway facilities. This indicator focuses on weekdays given that traffic congestion is generally greater on these days; this indicator does not capture traffic congestion on local streets due to data unavailability.\\n\\nThis congestion indicator emphasizes recurring delay (as opposed to also including non-recurring delay), capturing the extent of delay caused by routine traffic volumes (rather than congestion caused by unusual circumstances). Recurring delay is identified by setting a threshold of consistent delay greater than 15 minutes on a specific freeway segment from vehicle speeds less than 35 mph. This definition is consistent with longstanding practices by MTC, Caltrans and the U.S. Department of Transportation as speeds less than 35 mph result in significantly less efficient traffic operations. 35 mph is the threshold at which vehicle throughput is greatest; speeds that are either greater than or less than 35 mph result in reduced vehicle throughput. This methodology focuses on the extra travel time experienced based on a differential between the congested speed and 35 mph, rather than the posted speed limit.\\n\\nTo provide a mathematical example of how the indicator is calculated on a segment basis, when it comes to time spent in congestion, 1,000 vehicles traveling on a congested segment for a 1/4 hour (15 minutes) each, [1,000 vehicles x ¼ hour congestion per vehicle= 250 hours congestion], is equivalent to 100 vehicles traveling on a congested segment for 2.5 hours each, [100 vehicles x 2.5 hour congestion per vehicle = 250 hours congestion]. In this way, the measure captures the impacts of both slow speeds and heavy traffic volumes. \\n\\nMTC calculates two measures of delay – congested delay, or delay that occurs when speeds are below 35 miles per hour, and total delay, or delay that occurs when speeds are below the posted speed limit. To illustrate, if 1,000 vehicles are traveling at 30 miles per hour on a one mile long segment, this would represent 4.76 vehicle hours of congested delay [(1,000 vehicles x 1 mile / 30 miles per hour) - (1,000 vehicles x 1 mile / 35 miles per hour) = 33.33 vehicle hours – 28.57 vehicle hours = 4.76 vehicle hours]. Considering that the posted speed limit on the segment is 60 miles per hour, total delay would be calculated as 16.67 vehicle hours [(1,000 vehicles x 1 mile / 30 miles per hour) - (1,000 vehicles x 1 mile / 60 miles per hour) = 33.33 vehicle hours – 16.67 vehicle hours = 16.67 vehicle hours]. \\n\\nData sources listed above were used to calculate per-capita and per-worker statistics. Top congested corridors are ranked by total vehicle hours of delay, meaning that the highlighted corridors reflect a combination of slow speeds and heavy t\",\n            \"attribution\" : null,\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2018-10-24T00:31:33.000Z\",\n            \"createdAt\" : \"2018-08-20T23:44:47.000Z\",\n            \"metadata_updated_at\" : \"2018-10-24T00:31:33.000Z\",\n            \"data_updated_at\" : \"2018-10-16T16:09:17.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 1,\n                \"page_views_last_month\" : 6,\n                \"page_views_total\" : 588,\n                \"page_views_last_week_log\" : 1.0,\n                \"page_views_last_month_log\" : 2.807354922057604,\n                \"page_views_total_log\" : 9.20212382383046\n              },\n            \"columns_name\" :\n              [\n                \"VHD\",\n                \"Direction1\",\n                \"Direction2\",\n                \"County2\",\n                \"Source\",\n                \"StartHour\",\n                \"cs_rank\",\n                \"Year\",\n                \"EndHour\",\n                \"ID\",\n                \"County1\",\n                \"Location\",\n                \"rank\",\n                \"County3\",\n                \"Route1\",\n                \"Length\",\n                \"Route2\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"vhd\",\n                \"direction1\",\n                \"direction2\",\n                \"county2\",\n                \"source\",\n                \"starthour\",\n                \"cs_rank\",\n                \"year\",\n                \"endhour\",\n                \"id\",\n                \"county1\",\n                \"location\",\n                \"rank\",\n                \"county3\",\n                \"route1\",\n                \"length\",\n                \"route2\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Number\",\n                \"Number\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"Vehicle-hours of delay on segment, calculated as congested hours of delay times number of vehicles affected\",\n                \"Direction (NB, SB, etc.) of Route 1\",\n                \"Direction (NB, SB, etc.) of Route 2\",\n                \"If congested segment spans two counties, second county where congested segment is located\",\n                \"\",\n                \"Start hour of observed congestion\",\n                \"2017 congestion ranking for segment\",\n                \"\",\n                \"End hour of observed congestion\",\n                \"\",\n                \"County where congested segment is located\",\n                \"Start and endpoints of the congested segment\",\n                \"\",\n                \"\",\n                \"Freeway route number of congested segment\",\n                \"Length of congested segment in miles\",\n                \"If congested segment is shared by multiple freeways, second freeway route number\"\n              ],\n            \"columns_format\" :\n              [\n                { \"precision\" : \"0\" },\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                { \"noCommas\" : \"true\" },\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {}\n              ],\n            \"download_count\" : 120,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2018-09-14T23:34:44.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"transportation\", \"recreation\", \"education\" ],\n            \"tags\" : [],\n            \"domain_tags\" : [ \"vital signs\" ],\n            \"domain_metadata\" : []\n          },\n        \"metadata\" : { \"domain\" : \"data.bayareametro.gov\" },\n        \"permalink\" : \"https://data.bayareametro.gov/d/f57x-8ifw\",\n        \"link\" : \"https://data.bayareametro.gov/dataset/Vital-Signs-Time-in-Congestion-Corridor-Updated-Oc/f57x-8ifw\",\n        \"owner\" :\n          {\n            \"id\" : \"wg3i-tdm6\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Raleigh McCoy\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"wg3i-tdm6\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Raleigh McCoy\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"ED Private Establishments & Wages QCEW\",\n            \"id\" : \"26kz-atns\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Numbers of private-sector establishments in Pierce County, by quarter, reporting information about employment and wages on the Quarterly Census of Employment and Wages.\",\n            \"attribution\" : \"Bureau of Labor Statistics\",\n            \"attribution_link\" : \"https://www.bls.gov/cew/\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2024-04-17T20:58:45.000Z\",\n            \"createdAt\" : \"2019-07-31T21:59:49.000Z\",\n            \"metadata_updated_at\" : \"2024-04-17T20:58:43.000Z\",\n            \"data_updated_at\" : \"2024-04-17T20:58:45.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 1,\n                \"page_views_last_month\" : 5,\n                \"page_views_total\" : 286,\n                \"page_views_last_week_log\" : 1.0,\n                \"page_views_last_month_log\" : 2.584962500721156,\n                \"page_views_total_log\" : 8.16490692667569\n              },\n            \"columns_name\" :\n              [\n                \"Services-Producing Industries Wages\",\n                \"Total Wages\",\n                \"Goods-Producing Industries Wages\",\n                \"Goods Establishments\",\n                \"Date\",\n                \"Change in Total Establishments\",\n                \"Changes in Services Wages\",\n                \"Change in Services Establishments\",\n                \"Change in Goods Establishments\",\n                \"Change in Goods Wages\",\n                \"Total Establishments\",\n                \"Change in Total Wages\",\n                \"Services Establishments\",\n                \"Qtr.\",\n                \"Year\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"wages_s\",\n                \"wages_t\",\n                \"wages_g\",\n                \"estab_g\",\n                \"date\",\n                \"estab_chng_t\",\n                \"wages_chng_s\",\n                \"estab_chng_s\",\n                \"estab_chng_g\",\n                \"wages_chng_g\",\n                \"estab_t\",\n                \"wages_chng_t\",\n                \"estab_s\",\n                \"qtr\",\n                \"year\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Calendar date\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"Total wages paid by reporting establishments in \\\"services producing\\\" industries\",\n                \"Total wages paid by reporting establishments\",\n                \"Total wages paid by reporting establishments in \\\"goods producing\\\" industries\",\n                \"Total number of \\\"goods producing\\\" establishments\",\n                \"Middle of the quarter date\",\n                \"Change from previous quarter in total number of establishments\",\n                \"Change from previous quarter in wages paid by \\\"services producing\\\" establishments\",\n                \"Change from previous quarter in number of \\\"services producing\\\" establishments\",\n                \"Change from previous quarter in number of \\\"goods producing\\\" establishments\",\n                \"Change from previous quarter in wages paid by \\\"goods producing\\\" establishments\",\n                \"Total number of establishments\",\n                \"Change from previous quarter in total wages paid\",\n                \"Total number of \\\"services producing\\\" establishments\",\n                \"Data reporting quarter\",\n                \"Data reporting year\"\n              ],\n            \"columns_format\" :\n              [\n                {\n                  \"precisionStyle\" : \"currency\",\n                  \"noCommas\" : \"false\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                { \"precisionStyle\" : \"currency\", \"precision\" : \"0\" },\n                {\n                  \"precisionStyle\" : \"currency\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                {},\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"currency\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"currency\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                {},\n                {\n                  \"precisionStyle\" : \"currency\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                {},\n                {},\n                { \"noCommas\" : \"true\" }\n              ],\n            \"download_count\" : 53,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2019-07-31T22:17:30.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"economy\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Business\",\n            \"domain_tags\" : [],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Publishing_Department\",\n                  \"value\" : \"Economic Development\"\n                },\n                { \"key\" : \"Publishing_Dataset-Start-Year\", \"value\" : \"2008\" },\n                {\n                  \"key\" : \"Publishing_Strategic-Objective\",\n                  \"value\" : \"Jobs and Entrepreneurship\"\n                },\n                {\n                  \"key\" : \"Publishing_Priority-Areas\",\n                  \"value\" : \"Entrepreneurial Climate\"\n                },\n                {\n                  \"key\" : \"Publishing_Terms-of-Use\",\n                  \"value\" : \"https://internal.open.piercecountywa.gov/stories/s/t3r8-e9ff\"\n                },\n                {\n                  \"key\" : \"Publishing_Update-Frequency\",\n                  \"value\" : \"Quarterly\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"internal.open.piercecountywa.gov\" },\n        \"permalink\" : \"https://internal.open.piercecountywa.gov/d/26kz-atns\",\n        \"link\" : \"https://internal.open.piercecountywa.gov/Business/ED-Private-Establishments-Wages-QCEW/26kz-atns\",\n        \"owner\" :\n          {\n            \"id\" : \"5pem-6v9w\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Rob Allen\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"5pem-6v9w\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Rob Allen\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Weigh-In-Motion Station Vehicle Traffic Counts: 2013\",\n            \"id\" : \"7y2e-49j8\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This data set is a list of daily vehicle counts, in each direction, taken at the weigh-in-motion (WIM) stations operated by the New York State Department of Transportation (NYSDOT) during the 2013 calendar year.  Daily totals by direction are provided, as well as totals in each of 13 vehicle-type classes, and latitude-longitude locations of each station.\",\n            \"attribution\" : \"New York State Department of Transportation (DOT)\",\n            \"attribution_link\" : \"https://www.dot.ny.gov/divisions/engineering/technical-services/highway-data-services\",\n            \"contact_email\" : \"opendata@its.ny.gov\",\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2019-06-13T19:39:47.000Z\",\n            \"createdAt\" : \"2015-01-21T19:27:54.000Z\",\n            \"metadata_updated_at\" : \"2019-06-13T19:39:47.000Z\",\n            \"data_updated_at\" : \"2015-02-04T12:29:20.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 16,\n                \"page_views_last_month\" : 71,\n                \"page_views_total\" : 6608,\n                \"page_views_last_week_log\" : 4.08746284125034,\n                \"page_views_last_month_log\" : 6.169925001442312,\n                \"page_views_total_log\" : 12.69021628042204\n              },\n            \"columns_name\" :\n              [\n                \"Class 9\",\n                \"Class 13\",\n                \"Route\",\n                \"Class 8\",\n                \"Class 5\",\n                \"Class 3\",\n                \"Class 1\",\n                \"Count Date\",\n                \"Location 1 (zip)\",\n                \"Location 1 (state)\",\n                \"Location 1 (city)\",\n                \"New York Zip Codes\",\n                \"Months Used\",\n                \"Direction\",\n                \"Class 2\",\n                \"Class 4\",\n                \"Class 6\",\n                \"Class 7\",\n                \"Class 10\",\n                \"Class 11\",\n                \"Latitude\",\n                \"Longitude\",\n                \"Location 1\",\n                \"NYS Municipal Boundaries\",\n                \"Counties\",\n                \"Location 1 (address)\",\n                \"Lanes\",\n                \"Class 12\",\n                \"Station\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"class9\",\n                \"class13\",\n                \"route\",\n                \"class8\",\n                \"class5\",\n                \"class3\",\n                \"class1\",\n                \"count_date\",\n                \"location_1_zip\",\n                \"location_1_state\",\n                \"location_1_city\",\n                \":@computed_region_wbg7_3whc\",\n                \"months_used\",\n                \"direction\",\n                \"class2\",\n                \"class4\",\n                \"class6\",\n                \"class7\",\n                \"class10\",\n                \"class11\",\n                \"latitude\",\n                \"longitude\",\n                \"location_1\",\n                \":@computed_region_yamh_8v7k\",\n                \":@computed_region_kjdx_g34t\",\n                \"location_1_address\",\n                \"lanes\",\n                \"class12\",\n                \"station\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Point\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"The total number of single-trailer, five-axle trucks detected at the station, on the given day, in the given direction. These trucks (“18 wheelers”) are those most commonly used for long-distance road transport, and therefore are the main focus of NYSDOT’s weigh in motion program.\",\n                \"The total number of multi-trailer, seven-or-more-axle trucks detected at the station, on the given day, in the given direction.\",\n                \"Route name or number where the station is located\",\n                \"The total number of single-trailer, three- or four-axle trucks detected at the station, on the given day, in the given direction.\",\n                \"The total number of single-unit, two-axle trucks detected at the station, on the given day, in the given direction. These vehicles typically have dual-rear wheels. These vehicles do not have trailers.\",\n                \"The total number of pickups, panels, and vans detected at the station, on the given day, in the given direction. These vehicles are larger than passenger vehicles, always have two axles, and may pull a one- or two-axle trailer.\",\n                \"The total number of motorcycles detected at the station, on the given day, in the given direction. Motorcycles include all two- and three-wheeled vehicles.\",\n                \"The date the data was collected. Only weekdays (Mon-Fri) were used, and any date where the station failed to collect valid data (due to malfunctions, maintenance, etc.) was discarded.\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"The number of months included in the count based on the total number of weekdays the data was collected. Generally, only months with at least ten weekdays or two weeks of data are included.\",\n                \"The principal direction of traffic on the route (for example, north on a north-south road, east on an east-west road).\",\n                \"The total number of passenger vehicles detected at the station, on the given day, in the given direction. Passenger vehicles always have two axles, and may pull a one- or two-axle trailer.\",\n                \"The total number of buses detected at the station, on the given day, in the given direction. Buses may have two or three axles.\",\n                \"The total number of single-unit, three-axle trucks detected at the station, on the given day, in the given direction. These vehicles do not have trailers.\",\n                \"The total number of single-unit, four-or-more-axle trucks detected at the station, on the given day, in the given direction. These vehicles do not have trailers.\",\n                \"The total number of single-trailer, six-or-more-axle trucks detected at the station, on the given day, in the given direction.\",\n                \"The total number of multi-trailer, four- or five-axle trucks detected at the station, on the given day, in the given direction.\",\n                \"The latitude of the station, in degrees north of the equator.\",\n                \"The longitude of the station, in degrees west of the Prime Meridian.\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"The total number of lanes in both directions\",\n                \"The total number of multi-trailer, six-axle trucks detected at the station, on the given day, in the given direction.\",\n                \"DOT station number of the weigh in motion site\"\n              ],\n            \"columns_format\" :\n              [\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                { \"align\" : \"left\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                { \"view\" : \"date\", \"align\" : \"right\" },\n                {},\n                {},\n                {},\n                {},\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                { \"view\" : \"address_coords\", \"align\" : \"right\" },\n                {},\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"center\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"center\"\n                }\n              ],\n            \"download_count\" : 3103,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2015-02-04T12:42:18.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"transportation\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"traffic counts\", \"wim\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Common-Core_Publisher\",\n                  \"value\" : \"State of New York\"\n                },\n                {\n                  \"key\" : \"Common-Core_Contact-Name\",\n                  \"value\" : \"Open Data NY\"\n                },\n                {\n                  \"key\" : \"Common-Core_Contact-Email\",\n                  \"value\" : \"opendata@its.ny.gov\"\n                },\n                {\n                  \"key\" : \"Additional-Resources_See-Also\",\n                  \"value\" : \"https://www.dot.ny.gov/divisions/engineering/technical-services/highway-data-services/traffic-data\"\n                },\n                {\n                  \"key\" : \"Additional-Resources_See-Also-\",\n                  \"value\" : \"http://www.dot.ny.gov/tdv\"\n                },\n                {\n                  \"key\" : \"Additional-Resources_See-Also-\",\n                  \"value\" : \"http://www.fhwa.dot.gov/policyinformation/tmguide/\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Contact-Information\",\n                  \"value\" : \"Anthony.Torre@dot.ny.gov\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Granularity\",\n                  \"value\" : \"Weigh-in-motion station\"\n                },\n                { \"key\" : \"Dataset-Summary_Coverage\", \"value\" : \"Statewide\" },\n                {\n                  \"key\" : \"Dataset-Summary_Posting-Frequency\",\n                  \"value\" : \"Static - Not Updated\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Organization\",\n                  \"value\" : \"NYS DOT, Highway Data Service Bureau, Main Office\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Time-Period\",\n                  \"value\" : \"2013 calendar year\"\n                },\n                {\n                  \"key\" : \"Dataset-Information_Agency\",\n                  \"value\" : \"Transportation, Department of\"\n                },\n                {\n                  \"key\" : \"Disclaimers_Limitations\",\n                  \"value\" : \"Data were collected on business days (Monday through Friday) only and was not collected on Saturdays or Sundays.\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.ny.gov\" },\n        \"permalink\" : \"https://data.ny.gov/d/7y2e-49j8\",\n        \"link\" : \"https://data.ny.gov/Transportation/Weigh-In-Motion-Station-Vehicle-Traffic-Counts-201/7y2e-49j8\",\n        \"owner\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Gasoline Retail Prices Weekly Average by Region: Beginning January 2017\",\n            \"id\" : \"nqur-w4p7\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Gasoline retail prices weekly average by region dataset provides the weekly average retail gasoline prices for New York State and sixteen New York metropolitan regions in U.S. dollars per gallon.  Data is a weekly average from January 2017 through current.  \\n\\nAverage daily retail gasoline prices are collected from the American Automobile Association (AAA) Daily Fuel Gauge Report.  The AAA Daily Fuel Gauge Report prices are averaged to produce a weekly average retail price for New York State and each metropolitan region.\\n\\nThe New York State metropolitan regions in the dataset are Albany (Albany-Schenectady-Troy), Batavia, Binghamton, Buffalo (Buffalo-Niagara Falls), Dutchess (Dutchess-Putnam), Elmira, Glens Falls, Ithaca, Kingston, Nassau (Nassau-Suffolk), New York City, Rochester, Syracuse, Utica (Utica-Rome), Watertown (Watertown-Fort Drum), and White Plains.\\n\\nThe New York State Energy Research and Development Authority (NYSERDA) offers objective information and analysis, innovative programs, technical expertise, and support to help New Yorkers increase energy efficiency, save money, use renewable energy, and reduce reliance on fossil fuels. To learn more about NYSERDA’s programs, visit https://nyserda.ny.gov or follow us on X, Facebook, YouTube, or Instagram.\",\n            \"attribution\" : \"New York State Energy Research and Development Authority Performance Management and Evaluation Services Group\",\n            \"attribution_link\" : \"http://www.nyserda.ny.gov/Energy-Data-and-Prices-Planning-and-Policy/Energy-Prices-Data-and-Reports/EA-Reports-and-Studies/Weekly-Transportation-Fuels-Report.aspx\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-18T14:30:48.000Z\",\n            \"createdAt\" : \"2014-08-27T21:38:13.000Z\",\n            \"metadata_updated_at\" : \"2025-07-18T14:30:47.000Z\",\n            \"data_updated_at\" : \"2025-07-18T14:30:48.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 349,\n                \"page_views_last_month\" : 925,\n                \"page_views_total\" : 59286,\n                \"page_views_last_week_log\" : 8.451211111832329,\n                \"page_views_last_month_log\" : 9.854868383260238,\n                \"page_views_total_log\" : 15.855428175861848\n              },\n            \"columns_name\" :\n              [\n                \"Watertown Average ($/gal)\",\n                \"Ithaca Average ($/gal)\",\n                \"Glens Falls Average ($/gal)\",\n                \"Albany Average ($/gal)\",\n                \"Date\",\n                \"Batavia Average ($/gal)\",\n                \"Utica Average ($/gal)\",\n                \"Dutchess Average ($/gal)\",\n                \"Kingston Average ($/gal)\",\n                \"Binghamton Average ($/gal)\",\n                \"New York State Average ($/gal)\",\n                \"Nassau Average ($/gal)\",\n                \"Rochester Average ($/gal)\",\n                \"New York City Average ($/gal)\",\n                \"Elmira Average ($/gal)\",\n                \"Buffalo Average ($/gal)\",\n                \"White Plains Average ($/gal)\",\n                \"Syracuse Average ($/gal)\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"watertown_average_gal\",\n                \"ithaca_average_gal\",\n                \"glens_falls_average_gal\",\n                \"albany_average_gal\",\n                \"date\",\n                \"batavia_average_gal\",\n                \"utica_average_gal\",\n                \"dutchess_average_gal\",\n                \"kingston_average_gal\",\n                \"binghamton_average_gal\",\n                \"new_york_state_average_gal\",\n                \"nassau_average_gal\",\n                \"rochester_average_gal\",\n                \"new_york_city_average_gal\",\n                \"elmira_average_gal\",\n                \"buffalo_average_gal\",\n                \"white_plains_average_gal\",\n                \"syracuse_average_gal\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Calendar date\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"Weekly average regular grade gasoline price for Watertown-Fort Drum Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for Ithaca Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for Glens Falls Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for Albany-Schenectady-Troy Metropolitan Area ($/gallon).\",\n                \"Weekly Monday from October 2007 through Current.\",\n                \"Weekly average retail diesel price for Batavia Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for Utica-Rome Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for Dutchess-Putnam Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for Kingston Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for Binghamton Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for New York State ($/gallon).\",\n                \"Weekly average regular grade gasoline price for Nassau-Suffolk Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for Rochester Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for New York City Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for Elmira Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for Buffalo-Niagara Falls Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for White Plains Metropolitan Area ($/gallon).\",\n                \"Weekly average regular grade gasoline price for Syracuse Metropolitan Area ($/gallon).\"\n              ],\n            \"columns_format\" :\n              [\n                { \"precision\" : \"2\", \"align\" : \"right\" },\n                { \"noCommas\" : \"false\", \"precision\" : \"2\", \"align\" : \"right\" },\n                { \"precision\" : \"2\", \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"precision\" : \"2\",\n                  \"align\" : \"right\"\n                },\n                { \"view\" : \"date\", \"align\" : \"center\" },\n                { \"precision\" : \"2\", \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"precision\" : \"2\",\n                  \"align\" : \"right\"\n                },\n                { \"precision\" : \"2\", \"align\" : \"right\" },\n                { \"precision\" : \"2\", \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"precision\" : \"2\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"precision\" : \"2\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"precision\" : \"2\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"precision\" : \"2\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"precision\" : \"2\",\n                  \"align\" : \"right\"\n                },\n                { \"precision\" : \"2\", \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"precision\" : \"2\",\n                  \"align\" : \"right\"\n                },\n                { \"precision\" : \"2\", \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"precision\" : \"2\",\n                  \"align\" : \"right\"\n                }\n              ],\n            \"download_count\" : 34859,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2020-09-17T22:11:36.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"economy\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Energy & Environment\",\n            \"domain_tags\" :\n              [ \"energy prices\", \"gasoline\", \"transportation fuels\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Disclaimers_Limitations\",\n                  \"value\" : \"Weekly price data history was trimmed to 2017 to present in an effort to present a recent history, including a selection of years pre-pandemic (2017-2020), along with the pandemic and post-pandemic up to current. History prior to 2017 is available, but due to the extreme market changes and volatility over the past 5 years as well as the dynamic market and economic conditions decade-to-decade, NYSERDA decided to limit the historical data compilation to focus on a more recent history, with plans for the historical NY prices dataset not to exceed a decade.\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Dataset-Owner\",\n                  \"value\" : \"New York State Energy Research and Development Authority\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Contact-Information\",\n                  \"value\" : \"openny@nyserda.ny.gov; Rebecca.Gagnon@nyserda.ny.gov; Joseph.Osso@nyserda.ny.gov\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Granularity\",\n                  \"value\" : \"Metropolitan region\"\n                },\n                { \"key\" : \"Dataset-Summary_Coverage\", \"value\" : \"Statewide\" },\n                {\n                  \"key\" : \"Dataset-Summary_Posting-Frequency\",\n                  \"value\" : \"Weekly\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Organization\",\n                  \"value\" : \"NYSERDA Energy Market\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Time-Period\",\n                  \"value\" : \"Beginning January 2017\"\n                },\n                {\n                  \"key\" : \"Dataset-Information_Agency\",\n                  \"value\" : \"Energy Research and Development Authority\"\n                },\n                {\n                  \"key\" : \"Additional-Resources_See-Also\",\n                  \"value\" : \"American Automobile Association (AAA) Daily Fuel Gauge Report.  http://www.fuelgaugereport.com/\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.ny.gov\" },\n        \"permalink\" : \"https://data.ny.gov/d/nqur-w4p7\",\n        \"link\" : \"https://data.ny.gov/Energy-Environment/Gasoline-Retail-Prices-Weekly-Average-by-Region-Be/nqur-w4p7\",\n        \"owner\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          }\n      }\n    ],\n  \"resultSetSize\" : 887,\n  \"timings\" : { \"serviceMillis\" : 45, \"searchMillis\" : [ 5, 14 ] },\n  \"warnings\" : []\n}"), 
    timing = c(redirect = 0, namelookup = 1.9e-05, connect = 0, 
    pretransfer = 7.5e-05, starttransfer = 0.104318, total = 0.105879
    ), cache = new.env(parent = emptyenv())), class = "httr2_response")
