% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic.R
\name{ic}
\alias{ic}
\alias{ic,sf-method}
\alias{ic,SpatRaster-method}
\title{intersection cardinality}
\usage{
\S4method{ic}{sf}(
  data,
  column,
  target,
  lib = NULL,
  pred = NULL,
  E = 2:10,
  tau = 1,
  k = E + 2,
  nb = NULL,
  threads = detectThreads(),
  parallel.level = "low",
  detrend = FALSE
)

\S4method{ic}{SpatRaster}(
  data,
  column,
  target,
  lib = NULL,
  pred = NULL,
  E = 2:10,
  tau = 1,
  k = E + 2,
  threads = detectThreads(),
  parallel.level = "low",
  detrend = FALSE
)
}
\arguments{
\item{data}{observation data.}

\item{column}{name of library variable.}

\item{target}{name of target variable.}

\item{lib}{(optional) libraries indices.}

\item{pred}{(optional) predictions indices.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of spatial lags.}

\item{k}{(optional) number of nearest neighbors used.}

\item{nb}{(optional) neighbours list.}

\item{threads}{(optional) number of threads to use.}

\item{parallel.level}{(optional) level of parallelism, \code{low} or \code{high}.}

\item{detrend}{(optional) whether to remove the linear trend.}
}
\value{
A list
\describe{
\item{\code{xmap}}{cross mapping performance}
\item{\code{varname}}{name of target variable}
\item{\code{method}}{method of cross mapping}
\item{\code{tau}}{step of time lag}
}
}
\description{
intersection cardinality
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
\donttest{
ic(columbus,"hoval","crime", k = 25)
}
}
\references{
Tao, P., Wang, Q., Shi, J., Hao, X., Liu, X., Min, B., Zhang, Y., Li, C., Cui, H., Chen, L., 2023. Detecting dynamical causality by intersection cardinal concavity. Fundamental Research.
}
