% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spareg.R
\name{plot.spar}
\alias{plot.spar}
\title{plot.spar}
\usage{
\method{plot}{spar}(
  x,
  plot_type = c("val_measure", "val_numactive", "res_vs_fitted", "coefs"),
  plot_along = c("nu", "nummod"),
  nummod = NULL,
  nu = NULL,
  xfit = NULL,
  yfit = NULL,
  prange = NULL,
  coef_order = NULL,
  digits = 2L,
  ...
)
}
\arguments{
\item{x}{result of spar function of class  \code{'spar'}.}

\item{plot_type}{one of  \code{c("val_measure", "val_numactive", "res_vs_fitted", "coefs")}.}

\item{plot_along}{one of \code{c("nu","nummod")}; ignored when  \code{plot_type = "res_vs_fitted"}.}

\item{nummod}{fixed value for number of models when  \code{plot_along = "nu"}
for  \code{plot_type = "val_measure"} or  \code{"val_numactive"};
same as for \code{\link{predict.spar}} when  \code{plot_type="res_vs_fitted"}.}

\item{nu}{fixed value for \eqn{\nu} when  \code{plot_along="nummod"} for
\code{plot_type = "val_measure"} or  \code{"val_numactive"}; same as for \code{\link{predict.spar}} when  \code{plot_type="res_vs_fitted"}.}

\item{xfit}{data used for predictions in  \code{"res_vs_fitted"}.}

\item{yfit}{data used for predictions in  \code{"res_vs_fitted"}.}

\item{prange}{optional vector of length 2 for  \code{"coefs"}-plot to give
the limits of the predictors' plot range; defaults to  \code{c(1, p)}.}

\item{coef_order}{optional index vector of length p for \code{plot_type = "coefs"} to give
the order of the predictors; defaults to \code{1 : p}.}

\item{digits}{number of significant digits to be displayed in the axis; defaults to 2L.}

\item{...}{further arguments passed to or from other methods}
}
\value{
\code{'\link[ggplot2:ggplot]{ggplot2::ggplot}'}  object
}
\description{
Plot values of validation measure or number of active variables over different thresholds or number of models for \code{'spar'} object, or residuals vs fitted
}
