% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_nodes.R
\name{remove_nodes}
\alias{remove_nodes}
\title{Remove edges connected to certain nodes}
\usage{
remove_nodes(g, i, fuse = FALSE, verb = FALSE)
}
\arguments{
\item{g}{sg object}

\item{i}{indices of nodes for which to remove the edges}

\item{fuse}{Should the neighours of removed nodes be connected?}

\item{verb}{verbose?}
}
\description{
Remove the existence of particular nodes from the graph.
}
\details{
Basically, just clear the neighbourhood of selected indices. If fuse=TRUE,
connect neighbours together (excluding i's). Should work over several remove nodes
along a path.

Note: g should be symmetric. use sg2sym to force symmetry, it is not checked.

Warning: In development.
}
\examples{

x <- matrix(runif(200), ncol=2)
g <- spatgraph(x, "RST", c(1,0))
g <- sg2sym(g)
i <- sample(100, 50)
k <- setdiff(1:100, i)
gs <- remove_nodes(g, i, fuse=TRUE)
plot(g,x, add=FALSE)
points(x[k,], pch=19, col=4)
plot(gs, x, add=TRUE, lty=2, col=3)

}
