% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plant_richness_df.R
\docType{data}
\name{plant_richness_df}
\alias{plant_richness_df}
\title{Plant richness and predictors of American ecoregions}
\format{
A data frame with 227 rows and 22 columns:
\itemize{
\item \code{ecoregion_id}: Id of the ecoregion).
\item \code{x}: Longitude in degrees (WGS84).
\item \code{y}: Latitude in degrees (WGS84).
\item \code{richness_species_vascular}: Number of vascular species found in the ecoregion. Response variable.
\item \code{bias_area_km2}: Area of the ecoregion in squared kilometers.
\item \code{bias_species_per_record}: Number of species divided by the number of spatial GBIF records available in the ecoregion as a measure of sampling bias.
\item \code{climate_aridity_index_average}: Average of the ecoregion.
\item \code{climate_hypervolume}: Volume of the climatic envelope of the ecoregion, computed with the \href{https://cran.r-project.org/package=hypervolume}{hypervolume} package.
\item \code{climate_velocity_lgm_average}: Average climate velocity of the ecoregion since the Last Glacial Maximum.
\item \code{neighbors_count}: Number of immediate neighbors of the ecoregion as a measure of connectivity/isolation.
\item \code{neighbors_percent_shared_edge}: Percentage of shared edge with the neighbors as a measure of connectivity/isolation.
\item \code{human_population_density}: Population density of the ecoregion.
\item \code{topography_elevation_average}: Average elevation of the ecoregion.
\item \code{landcover_herbs_percent_average}: Average cover percentage of herbs extracted from MODIS Vegetation Continuous Fields.
\item \code{fragmentation_cohesion}: Geographic fragmentation index of the ecoregion as computed with the R package \href{https://CRAN.R-project.org/package=landscapemetrics}{landscapemetrics}.
\item \code{fragmentation_division}: Another fragmentation index.
\item \code{neighbors_area}: Total area of the ecoregions's immediate neighbors.
\item \code{human_population}: Human population in the ecoregion.
\item \code{human_footprint_average}: Average human footprint in the ecoregion.
\item \code{climate_bio1_average}: Average mean annual temperature.
\item \code{climate_bio15_minimum}: Average precipitation seasonality.

}
}
\usage{
data(plant_richness_df)
}
\description{
Richness of vascular plants of the American ecoregions as defined in \href{https://ecoregions2017.appspot.com/}{Ecoregions 2017}.
}
\seealso{
\link{distance_matrix}
}
\keyword{datasets}
