% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.slmfit.R
\name{print.slmfit}
\alias{print.slmfit}
\title{Prints the fitted coefficient table of a fitted spatial linear model.}
\usage{
\method{print}{slmfit}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{is an object generated from \code{\link{slmfit}()}}

\item{digits}{is the number of digits to be displayed in the
model output}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with \itemize{
  \item model formula
  \item summary statistics for the residuals.
  \item a table of fixed effects estimates and associated standard errors.
  \item estimated spatial covariance parameter estimates.
  \item generalized r-squared value.
}
}
\description{
This function uses the object that is output from \code{\link{slmfit}()} of class \code{slmfit}.
}
\examples{
data(exampledataset) ## load a toy data set
slmobj <- slmfit(formula = counts ~ pred1 + pred2, data = exampledataset,
xcoordcol = 'xcoords', ycoordcol = 'ycoords', areacol = 'areavar')
print(slmobj)
}
