% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.slmfit.R
\name{summary.slmfit}
\alias{summary.slmfit}
\title{Summarizes a fitted spatial linear model.}
\usage{
\method{summary}{slmfit}(object, ...)
}
\arguments{
\item{object}{is an object generated from \code{\link{slmfit}()} of class \code{slmfit}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with \itemize{
  \item model formula
  \item a table of fixed effects estimates and associated standard errors
  \item estimated spatial covariance parameter estimates
  \item residuals
  \item generalized r-squared.
       }
}
\description{
In conjunction with \code{print.summary.slmfit()}, the output looks similar
to output from \code{R}'s standard \code{lm()} function.
}
\examples{
data(exampledataset) ## load a toy data set
slmobj <- slmfit(formula = counts ~ pred1 + pred2, data = exampledataset,
xcoordcol = 'xcoords', ycoordcol = 'ycoords', areacol = 'areavar')
summary(slmobj)
}
