% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCA_helpers.R
\name{scores}
\alias{scores}
\title{Calculate Scores for local sparse PCA}
\usage{
scores(X, PC, groups, ssMRCD = NULL)
}
\arguments{
\item{X}{data set as matrix.}

\item{PC}{loading matrix.}

\item{groups}{vector of grouping structure (numeric).}

\item{ssMRCD}{ssMRCD object used for scaling \code{X}. If \code{NULL} no scaling and centering is performed.}
}
\value{
Returns a list with scores and univariately and locally centered and scaled observations.
}
\description{
Calculate Scores for local sparse PCA
}
\examples{
# create data set
x1 = matrix(runif(200), ncol = 2)
x2 = matrix(rnorm(200), ncol = 2)
x = list(x1, x2)

# create weighting matrix
W = matrix(c(0, 1, 1, 0), ncol = 2)

# calculate ssMRCD
loccovs = ssMRCD(x, weights = W, lambda = 0.5)

# calculate PCA
pca = sparsePCAloc(eta = 1, gamma = 0.5, cor = FALSE,
                   COVS = loccovs$MRCDcov,
                   increase_rho = list(FALSE, 20, 1))

# calculate scores
scores(X = rbind(x1, x2), PC = pca$PC,
       groups = rep(c(1,2), each = 100), ssMRCD = loccovs)
}
\seealso{
\code{\link[ssMRCD]{ssMRCD}}, \code{\link[ssMRCD]{scale_ssMRCD}}
}
