% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{fun_date_extraction}
\alias{fun_date_extraction}
\title{This function extracts temporal characteristics from a dataframe}
\usage{
fun_date_extraction(
  data,
  nom_coldt,
  annee = TRUE,
  mois = TRUE,
  quinzaine = FALSE,
  semaine = TRUE,
  semaine_std = FALSE,
  jour_an = FALSE,
  jour_mois = TRUE,
  heure = FALSE
)
}
\arguments{
\item{data}{a data frame containing a Date or POSIXt column}

\item{nom_coldt}{the name of the column containing date or POSIXt entry to
be processed}

\item{annee}{logical do you want a column describing year to be added to the
dataframe}

\item{mois}{logical, add column with month}

\item{quinzaine}{logical, add column with 15 days}

\item{semaine}{logical, add column with weeks}

\item{semaine_std}{logical, add column with standard weeks (using isoweek from lubridate)}

\item{jour_an}{logical, add column with day of year}

\item{jour_mois}{logical, add column with day of month}

\item{heure}{logical, add column with hour}
}
\value{
The dataframe with date column filled
}
\description{
This function extracts temporal characteristics from a dataframe
}
\author{
Cedric Briand \email{cedric.briand@eptb-vilaine.fr}
}
