% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stacomi.R
\name{stacomi}
\alias{stacomi}
\title{stacomi Main launcher for program stacomi}
\usage{
stacomi(database_expected=TRUE, datawd = "~", sch = "test")
}
\arguments{
\item{database_expected}{Boolean, if \code{TRUE} pre launch tests will be run to test the connection validity}

\item{datawd}{The data working directory}

\item{sch}{The schema in the stacomi database default 'test'.}
}
\value{
Nothing, called for its side effect of loading
}
\description{
When \code{database_expected=FALSE} a connection to the database is not expected. Therefore test are run by calling examples object stored in Rdata.
To change the language use Sys.setenv(LANG = 'fr') or Sys.setenv(LANG = 'en')
}
\examples{

 require(stacomiR)
#launch stacomi 
 \dontrun{ 
stacomi(database_expected=TRUE, datawd='~',sch= "iav")
}
# launch stacomi without connection to the database
stacomi(database_expected=FALSE)
# launch stacomi with options
options(
	stacomiR.dbname = "bd_contmig_nat",
	stacomiR.host = readline(prompt = "Enter host: "),
	stacomiR.port = "5432",
	stacomiR.user = readline(prompt = "Enter user: "),
	stacomiR.password = readline(prompt = "Enter password: ")
)
# another usefull option to print all queries run by stacomiR to the console
 options('stacomiR.printqueries'= TRUE)
}
\author{
Cedric Briand \email{cedric.briand@eptb-vilaine.fr}
}
