% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{visualisation}
\alias{visualisation}
\title{Visualise the results of a *steps* simulation}
\description{
Visualising the results of a simulation is important to verify parameter assumptions
and quantitative model behaviour. Both linear graphs indicating trends and
spatial-explicit grids containing spatial arrangement of information can be generated
to illustrate changes through time and space for populations, carrying capacity,
and habitat suitability. The expected minimum populations (EMP) can also be compared
for several different simulations.
}
\details{
For plotting trends, see:
\itemize{
\item{\code{\link[steps]{plot_pop_trend}} to examine population changes}
\item{\code{\link[steps]{plot_k_trend}} to examine carrying capacity changes}
}

For plotting spatial information, see:
\itemize{
\item{\code{\link[steps]{plot_pop_spatial}} to examine population changes}
\item{\code{\link[steps]{plot_k_spatial}} to examine carrying capacity changes}
\item{\code{\link[steps]{plot_hab_spatial}} to examine habitat suitability changes}
}

For plotting and comparing expected minimum populations, see:
\itemize{
\item{\code{\link[steps]{compare_emp}} to examine how different simulations compare}
}
}
