% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r1sd.R
\name{r1sd}
\alias{r1sd}
\title{Scale a vector by one standard deviation}
\usage{
r1sd(x, na = TRUE)
}
\arguments{
\item{x}{a numeric vector}

\item{na}{what to do with NAs in the vector. Defaults to TRUE (i.e. passes over the missing observations)}
}
\value{
The function returns a numeric vector rescaled with a mean of 0 and a
standard deviation of 1.
}
\description{
\code{r1sd} allows you to rescale a numeric vector such that the
ensuing output has a mean of 0 and a standard deviation of 1.
}
\details{
This is a convenience function since the default \code{rescale()} function
has some additional weirdness that is not welcome for my use cases. By default,
\code{na.rm} is set to TRUE.
}
\examples{

x <- rnorm(100)
r1sd(x)
}
