% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique.stlpp.R
\name{unique.stlpp}
\alias{unique.stlpp}
\title{Extract unique points from a spatio-temporal point pattern on a linear network}
\usage{
\method{unique}{stlpp}(x,...)
}
\arguments{
\item{x}{a spatio-temporal point pattern of class \code{\link{stlpp}}}

\item{...}{arguments for \code{\link{unique}}}
}
\value{
A spatio-temporal point pattern on a linear network with no duplicated point.
}
\description{
This function extracts unique points from a spatio-temporal point pattern on a linear network.
}
\details{
This function extracts unique points from a spatio-temporal point pattern on a linear network.
}
\examples{
 
X <-  rpoistlpp(0.1,0,5,L=easynet)
df <- as.data.frame(X)
df_dup <- df[sample(nrow(df), 20,replace = TRUE), ]
Y <- as.stlpp(df_dup,L=easynet)
npoints(Y)
npoints(unique(Y))



}
\references{
Moradi, M., & Mateu, J. (2020). First-and second-order characteristics of spatio-temporal point processes on linear networks. Journal of Computational and Graphical Statistics, 29(3), 432-443.
}
\seealso{
\code{\link{unique}}
}
\author{
Mehdi Moradi <m2.moradi@yahoo.com>
}
