% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{computeForestMaxLeafIndex}
\alias{computeForestMaxLeafIndex}
\title{Compute and return the largest possible leaf index computable by \code{computeForestLeafIndices} for the forests in a designated forest sample container.}
\usage{
computeForestMaxLeafIndex(
  model_object,
  covariates,
  forest_type = NULL,
  forest_inds = NULL
)
}
\arguments{
\item{model_object}{Object of type \code{bartmodel}, \code{bcfmodel}, or \code{ForestSamples} corresponding to a BART / BCF model with at least one forest sample, or a low-level \code{ForestSamples} object.}

\item{covariates}{Covariates to use for prediction. Must have the same dimensions / column types as the data used to train a forest.}

\item{forest_type}{Which forest to use from \code{model_object}.
Valid inputs depend on the model type, and whether or not a

\strong{1. BART}
\itemize{
\item \code{'mean'}: Extracts leaf indices for the mean forest
\item \code{'variance'}: Extracts leaf indices for the variance forest
}

\strong{2. BCF}
\itemize{
\item \code{'prognostic'}: Extracts leaf indices for the prognostic forest
\item \code{'treatment'}: Extracts leaf indices for the treatment effect forest
\item \code{'variance'}: Extracts leaf indices for the variance forest
}

\strong{3. ForestSamples}
\itemize{
\item \code{NULL}: It is not necessary to disambiguate when this function is called directly on a \code{ForestSamples} object. This is the default value of this
}}

\item{forest_inds}{(Optional) Indices of the forest sample(s) for which to compute max leaf indices. If not provided,
this function will return max leaf indices for every sample of a forest.
This function uses 0-indexing, so the first forest sample corresponds to \code{forest_num = 0}, and so on.}
}
\value{
Vector containing the largest possible leaf index computable by \code{computeForestLeafIndices} for the forests in a designated forest sample container.
}
\description{
Compute and return the largest possible leaf index computable by \code{computeForestLeafIndices} for the forests in a designated forest sample container.
}
\examples{
X <- matrix(runif(10*100), ncol = 10)
y <- -5 + 10*(X[,1] > 0.5) + rnorm(100)
bart_model <- bart(X, y, num_gfr=0, num_mcmc=10)
computeForestMaxLeafIndex(bart_model, X, "mean")
computeForestMaxLeafIndex(bart_model, X, "mean", 0)
computeForestMaxLeafIndex(bart_model, X, "mean", c(1,3,9))
}
