% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochvol-cpp-doc.R
\name{update_general_sv}
\alias{update_general_sv}
\title{Single MCMC Update Using General SV}
\usage{
update_general_sv(
  data,
  log_data2,
  sign_data,
  mu,
  phi,
  sigma,
  rho,
  h0,
  h,
  adaptation,
  prior_spec,
  expert
)
}
\arguments{
\item{data}{the vector of de-meaned observations}

\item{log_data2}{log(data^2), where data is the vector of de-meaned observations}

\item{sign_data}{the sign of the data}

\item{mu}{parameter mu. Level of the latent process h. Updated in place}

\item{phi}{parameter phi, persistence of the latent process h. Updated in place}

\item{sigma}{parameter sigma, volatility of the latent process h, also called volvol. Updated in place}

\item{rho}{parameter rho. Accounts for asymmetry/the leverage effect. Updated in place}

\item{h0}{parameter h0, the initial value of the latent process h. Updated in place}

\item{h}{the vector of the latent process. Updated in place}

\item{adaptation}{object implementing the adaptive Metropolis-Hastings scheme. Updated in place. See adaptation.hpp}

\item{prior_spec}{prior specification object. See type_definitions.h}

\item{expert}{expert settings for this function. See type_definitions.h}
}
\description{
Samples the latent variables and the model independent parameters mu, phi, sigma,
and rho. The observations need to be provided in different formats for efficiency.
An approximate SV model is as the default posterior distribution for the latent vector; however,
there is the option to correct for model misspecification through the expert settings.
Depending on the prior specification, some of mu, phi, sigma, and rho might not be updated.
Depending on the expert settings, the function might follow the ancillarity-sufficiency
interweaving strategy (ASIS, Yu and Meng, 2011) for sampling mu, phi, sigma, and rho.
Also controlled by the expert settings, 
Furthermore, the user can turn off the sampling of the parameters, the latents, or the
mixture indicators in the expert settings.
}
\seealso{
Other stochvol_cpp: 
\code{\link{update_fast_sv}()},
\code{\link{update_regressors}()},
\code{\link{update_t_error}()}
}
\concept{stochvol_cpp}
\keyword{update}
