% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{loss_one_minus_c_index}
\alias{loss_one_minus_c_index}
\title{Calculate the Concordance index loss}
\usage{
loss_one_minus_c_index(y_true = NULL, risk = NULL, surv = NULL, times = NULL)
}
\arguments{
\item{y_true}{a \code{survival::Surv} object containing the times and statuses of observations for which the metric will be evaluated}

\item{risk}{a numeric vector of risk scores corresponding to each observation}

\item{surv}{ignored, left for compatibility with other metrics}

\item{times}{ignored, left for compatibility with other metrics}
}
\value{
numeric from 0 to 1, lower values indicate better performance
}
\description{
This function subtracts the C-index metric from one to obtain a loss function whose lower values indicate better model performance (useful for permutational feature importance)
}
\examples{
\donttest{
library(survival)
library(survex)

rotterdam <- survival::rotterdam
rotterdam$year <- NULL
cox_rotterdam_rec <- coxph(Surv(rtime, recur) ~ .,
    data = rotterdam,
    model = TRUE, x = TRUE, y = TRUE)
coxph_explainer <- explain(cox_rotterdam_rec)

risk <- coxph_explainer$predict_function(coxph_explainer$model, coxph_explainer$data)
loss_one_minus_c_index(y_true = coxph_explainer$y, risk = risk)
}
}
\seealso{
\code{\link[=c_index]{c_index()}}
}
