% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.surveytable_table.R
\name{print.surveytable_table}
\alias{print.surveytable_table}
\alias{print.surveytable_list}
\title{Print surveytable tables}
\usage{
\method{print}{surveytable_table}(x, ...)

\method{print}{surveytable_list}(x, ...)
}
\arguments{
\item{x}{an object of class \code{surveytable_table} or \code{surveytable_list}.}

\item{...}{passed to helper functions.}
}
\value{
Returns \code{x} invisibly.
}
\description{
If a tabulation function is called from the top level, it should print out
its table(s) on its own. If that tabulation function is called not from the
top level, such as from within a loop or another function, you need to call
\code{print()} explicitly. For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{set_survey(namcs2019sv)
for (vr in c("AGER", "SEX")) \{
  print( tab_subset(vr, "MAJOR", "Preventive care") )
\}
}\if{html}{\out{</div>}}
}
\details{
The package used to produce the tables can be changed -- see the \code{output} argument
of \code{\link[=set_opts]{set_opts()}} for details. By default, the table-making package \code{huxtable} is used.
}
\examples{
set_survey(namcs2019sv)
table1 = tab("AGER")
print(table1)
table_many = tab("MDDO", "SPECCAT", "MSA")
print(table_many)
}
\concept{print}
