% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_ss.R
\name{compute_suff_stat}
\alias{compute_suff_stat}
\title{Compute sufficient statistics for input to \code{susie_suff_stat}}
\usage{
compute_suff_stat(X, y, standardize = FALSE)
}
\arguments{
\item{X}{An n by p matrix of covariates.}

\item{y}{An n vector.}

\item{standardize}{Logical flag indicating whether to standardize
columns of X to unit variance prior to computing summary data}
}
\value{
A list of sufficient statistics (\code{XtX, Xty, yty, n})
  and \code{X_colmeans}, \code{y_mean}.
}
\description{
Computes the sufficient statistics \eqn{X'X, X'y, y'y}
  and \eqn{n} after centering (and possibly standardizing) the
  columns of \eqn{X} and centering \eqn{y} to have mean zero. We also
  store the column means of \eqn{X} and mean of \eqn{y}.
}
\examples{
data(N2finemapping)
ss = compute_suff_stat(N2finemapping$X, N2finemapping$Y[,1])

}
