/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import java.util.concurrent.atomic.AtomicReferenceArray;
import main.GenotypeValues;
import main.SampleGenotypeValues;
import vcf.Marker;
import vcf.Markers;

public final class BasicGenotypeValues
implements GenotypeValues {
    private final Markers markers;
    private final Samples samples;
    private final AtomicReferenceArray<SampleGenotypeValues> values;

    public BasicGenotypeValues(Markers markers, Samples samples) {
        if (markers == null) {
            throw new NullPointerException("markers==null");
        }
        if (samples == null) {
            throw new NullPointerException("samples==null");
        }
        this.markers = markers;
        this.samples = samples;
        this.values = new AtomicReferenceArray(samples.nSamples());
        int n = samples.nSamples();
        for (int i = 0; i < n; ++i) {
            this.values.set(i, new SampleGenotypeValues(markers, i));
        }
    }

    @Override
    public float value(int n, int n2, int n3) {
        return this.values.get(n2).value(n, n3);
    }

    @Override
    public void add(int n, double[] dArray) {
        this.values.get(n).add(dArray);
    }

    @Override
    public void add(int n, int n2, int n3, double d) {
        this.values.get(n2).add(n, n3, d);
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }
}

