/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import blbutil.FileUtil;
import blbutil.IntPair;
import haplotype.SampleHapPairs;
import ibd.IbdSegment;
import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import main.GenotypeValues;
import vcf.VcfWriter;

public class WindowWriter {
    private static final DecimalFormat df2 = new DecimalFormat("#.##");
    private boolean isClosed = false;
    private boolean appendIbd = false;
    private final Samples samples;
    private final File vcfOutFile;
    private final File ibdOutFile;
    private final File hbdOutFile;
    private final PrintWriter vcfOut;
    private final Map<IntPair, IbdSegment> ibdBuffer = new HashMap<IntPair, IbdSegment>();

    public WindowWriter(Samples samples, String string) {
        if (samples == null) {
            throw new NullPointerException("samples==null");
        }
        if (string == null) {
            throw new NullPointerException("outPrefix==null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("outPrefix.length()==0");
        }
        this.samples = samples;
        this.vcfOutFile = new File(string + ".vcf.gz");
        this.ibdOutFile = new File(string + ".ibd");
        this.hbdOutFile = new File(string + ".hbd");
        this.vcfOut = FileUtil.bgzipPrintWriter(this.vcfOutFile);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        VcfWriter.writeMetaLines(samples.ids(), "beagle.jar (r1399)", bl, bl2, bl3, this.vcfOut);
    }

    public Samples samples() {
        return this.samples;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() {
        this.vcfOut.close();
        this.isClosed = true;
    }

    public void print(SampleHapPairs sampleHapPairs, GenotypeValues genotypeValues, Map<IntPair, List<IbdSegment>> map, int n, int n2, int n3) {
        if (this.isClosed) {
            throw new IllegalStateException("isClosed()==true");
        }
        this.checkData(sampleHapPairs, genotypeValues, n, n2, n3);
        if (genotypeValues == null) {
            VcfWriter.appendRecords(sampleHapPairs, n, n3, this.vcfOut);
        } else {
            VcfWriter.appendRecords(sampleHapPairs, genotypeValues, n, n3, this.vcfOut);
        }
        this.vcfOut.flush();
        if (map != null) {
            this.printIbd(map, n, n2, n3, sampleHapPairs.nMarkers());
            if (!this.appendIbd) {
                this.appendIbd = true;
            }
        }
    }

    private void checkData(SampleHapPairs sampleHapPairs, GenotypeValues genotypeValues, int n, int n2, int n3) {
        if (!this.samples.equals(sampleHapPairs.samples()) || genotypeValues != null && !this.samples.equals(genotypeValues.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        if (genotypeValues != null && !sampleHapPairs.markers().equals(genotypeValues.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (n < 0 || n > n2 || n2 > n3 || n3 > sampleHapPairs.nMarkers()) {
            throw new IndexOutOfBoundsException("index error");
        }
    }

    private void printIbd(Map<IntPair, List<IbdSegment>> map, int n, int n2, int n3, int n4) {
        HashMap<IntPair, IbdSegment> hashMap = new HashMap<IntPair, IbdSegment>(this.ibdBuffer);
        this.ibdBuffer.clear();
        try (PrintWriter printWriter = FileUtil.printWriter(this.ibdOutFile, this.appendIbd);
             PrintWriter printWriter2 = FileUtil.printWriter(this.hbdOutFile, this.appendIbd);){
            Iterator<IntPair> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                IntPair intPair = iterator.next();
                List<IbdSegment> list = map.get(intPair);
                for (IbdSegment ibdSegment : list) {
                    int n5;
                    IbdSegment ibdSegment2;
                    if (ibdSegment.startIndex() == 0 && (ibdSegment2 = (IbdSegment)hashMap.get(intPair)) != null) {
                        ibdSegment = WindowWriter.merge(ibdSegment2, ibdSegment);
                    }
                    if ((n5 = ibdSegment.endIndex() + 1) >= n && (n3 == n4 || n5 < n3)) {
                        WindowWriter.printSegment(this.samples, ibdSegment, printWriter, printWriter2);
                        continue;
                    }
                    if (ibdSegment.startIndex() >= n2) continue;
                    this.ibdBuffer.put(intPair, ibdSegment);
                }
                iterator.remove();
            }
        }
    }

    private static IbdSegment merge(IbdSegment ibdSegment, IbdSegment ibdSegment2) {
        assert (ibdSegment.hapPair().equals(ibdSegment2.hapPair()));
        assert (ibdSegment.start().chromIndex() == ibdSegment2.start().chromIndex());
        int n = -1;
        float f = Math.max(ibdSegment.score(), ibdSegment2.score());
        return new IbdSegment(ibdSegment.hapPair(), ibdSegment.start(), ibdSegment2.end(), f, n, ibdSegment2.endIndex());
    }

    private static void printSegment(Samples samples, IbdSegment ibdSegment, PrintWriter printWriter, PrintWriter printWriter2) {
        int n;
        int n2;
        int n3 = ibdSegment.hap1();
        int n4 = n3 / 2;
        PrintWriter printWriter3 = n4 == (n2 = (n = ibdSegment.hap2()) / 2) ? printWriter2 : printWriter;
        printWriter3.print(samples.id(n4));
        printWriter3.print('\t');
        printWriter3.print(n3 % 2 + 1);
        printWriter3.print('\t');
        printWriter3.print(samples.id(n2));
        printWriter3.print('\t');
        printWriter3.print(n % 2 + 1);
        printWriter3.print('\t');
        printWriter3.print(ibdSegment.start().chrom());
        printWriter3.print('\t');
        printWriter3.print(ibdSegment.start().pos());
        printWriter3.print('\t');
        printWriter3.print(ibdSegment.end().pos());
        printWriter3.print('\t');
        printWriter3.println(df2.format(ibdSegment.score()));
    }
}

